<?php

/**
 * i-doit
 *
 * Export helper for global category password.
 *
 * @package     i-doit
 * @subpackage  Export
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_global_cmk_tag_export_helper extends isys_export_helper
{
    /**
     * @return isys_export_data
     */
    public function tags()
    {
        $tags = isys_cmdb_dao_category_g_cmk_tag::instance($this->m_database)
            ->dynamic_property_callback_static_tags($this->m_row['isys_catg_cmk_tag_list__id'], $this->m_row);

        return new isys_export_data($tags);
    }

    /**
     * @param  array $exportData
     *
     * @return string|boolean
     */
    public function tags_import($exportData)
    {
        return isset($exportData[C__DATA__VALUE]) ? $exportData[C__DATA__VALUE] : false;
    }

    /**
     * @return array
     * @throws isys_exception_database
     */
    public function cmdbTags()
    {
        return isys_cmdb_dao_category_g_cmk_tag::instance($this->m_database)
            ->dynamic_property_callback_cmdb_tags($this->m_row['isys_catg_cmk_tag_list__id'], $this->m_row);
    }

    /**
     * This property is not writable!
     *
     * @return null
     */
    public function cmdbTags_import()
    {
        return null;
    }

    /**
     * @return array
     */
    public function dynamicTags()
    {
        return isys_cmdb_dao_category_g_cmk_tag::instance($this->m_database)
            ->dynamic_property_callback_dynamic_tags($this->m_row['isys_catg_cmk_tag_list__id'], $this->m_row);
    }

    /**
     * This property is not writable!
     *
     * @return null
     */
    public function dynamicTags_import()
    {
        return null;
    }
}