<?php

/**
 * i-doit
 *
 * UI: global category for Check_MK.
 *
 * @package     Modules
 * @subpackage  Check_MK
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4.0
 */
class isys_cmdb_ui_category_g_cmk_tag extends isys_cmdb_ui_category_global
{
    /**
     * Gets the template file.
     *
     * @return  string
     */
    public function get_template()
    {
        return isys_module_check_mk::get_tpl_dir() . 'modules/cmdb/catg__cmk_tag.tpl';
    }

    /**
     * Processes the UI for the category check_mk.
     *
     * @param   isys_cmdb_dao_category_g_cmk_tag $p_cat
     *
     * @author  Leonard Fischer <lfischer@i-doit.com>
     * @return  void
     */
    public function process(isys_cmdb_dao_category $p_cat)
    {
        $l_rules = [];
        $l_catdata = $p_cat->get_general_data();

        $this->fill_formfields($p_cat, $l_rules, $l_catdata);

        if (is_array($l_catdata) && $l_catdata['isys_catg_cmk_tag_list__id'] > 0) {
            try {
                $cmdbTags = $p_cat->dynamic_property_callback_cmdb_tags($l_catdata['isys_catg_cmk_tag_list__id'], $l_catdata);
            } catch (Exception $e) {
                $cmdbTags = [];
                isys_notify::error($e->getMessage(), ['sticky' => true]);
            }

            try {
                $dynamicTags = $p_cat->dynamic_property_callback_dynamic_tags($l_catdata['isys_catg_cmk_tag_list__id'], $l_catdata);
            } catch (Exception $e) {
                $dynamicTags = [];
                isys_notify::error($e->getMessage(), ['sticky' => true]);
            }

            if (count($cmdbTags)) {
                $this->get_template_component()
                    ->assign('cmdb_tags', isys_factory::get_instance('isys_smarty_plugin_f_dialog_list')
                        ->navigation_view($this->get_template_component(), [
                            'name'     => 'cmdb_tags',
                            'p_arData' => $cmdbTags
                        ]));
            }

            if (count($dynamicTags)) {
                $this->get_template_component()
                    ->assign('dynamic_tags', isys_factory::get_instance('isys_smarty_plugin_f_dialog_list')
                        ->navigation_view($this->get_template_component(), [
                            'name'     => 'dynamic_tags',
                            'p_arData' => $dynamicTags
                        ]));
            }
        }

        $this->get_template_component()
            ->smarty_tom_add_rules("tom.content.bottom.content", $l_rules);
    }
}