<?php
/**
 * i-doit
 *
 * Module initializer
 *
 * @package     Modules
 * @subpackage  Check_MK
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4.0
 */

define('C__CATG_CHECK_MK__NAME_SELECTION__INPUT', 0);
define('C__CATG_CHECK_MK__NAME_SELECTION__HOSTNAME_FQDN', 1);
define('C__CATG_CHECK_MK__NAME_SELECTION__HOSTNAME', 2);
define('C__CATG_CHECK_MK__NAME_SELECTION__OBJ_ID', 3);

define('C__MODULE__CMK__DYNAMIC_TAG__OBJECT_TYPE', 1);
define('C__MODULE__CMK__DYNAMIC_TAG__LOCATION', 2);
define('C__MODULE__CMK__DYNAMIC_TAG__PURPOSE', 3);

define('C__MODULE__CHECK_MK__LIVESTATUS_TYPE__TCP', 'tcp');
define('C__MODULE__CHECK_MK__LIVESTATUS_TYPE__UNIX', 'unix');

define('C__MODULE__CHECK_MK__LIVESTATUS_STATE__OK', 0);
define('C__MODULE__CHECK_MK__LIVESTATUS_STATE__WARNING', 1);
define('C__MODULE__CHECK_MK__LIVESTATUS_STATE__CRITICAL', 2);
define('C__MODULE__CHECK_MK__LIVESTATUS_STATE__UNKNOWN', 3);

define('C__MODULE__CHECK_MK__LIVESTATUS_STATE__UP', 0);
define('C__MODULE__CHECK_MK__LIVESTATUS_STATE__DOWN', 1);
define('C__MODULE__CHECK_MK__LIVESTATUS_STATE__UNREACHABLE', 2);

if (isys_module_manager::instance()
    ->is_active('check_mk')) {
    if (include_once('isys_module_check_mk_autoload.class.php')) {
        spl_autoload_register('isys_module_check_mk_autoload::init');
    }

    if (class_exists('\idoit\Psr4AutoloaderClass')) {
        \idoit\Psr4AutoloaderClass::factory()
            ->addNamespace('idoit\Module\Check_mk', __DIR__ . '/src/');
    }

    // Handle module specific language files.
    $l_lang = isys_application::instance()->container->session->get_language();

    if (file_exists(__DIR__ . '/lang/' . $l_lang . '.inc.php')) {
        $l_language = include_once(__DIR__ . '/lang/' . $l_lang . '.inc.php');

        if (is_array($l_language)) {
            isys_application::instance()->container->get('language')
                ->append_lang($l_language);
        }
    }

    isys_tenantsettings::extend([
        'Check_MK' => [
            'check_mk.validate-tags' => [
                'title'   => 'LC__MODULE__CHECK_MK__SETTING__VALIDATE_TAGS',
                'type'    => 'select',
                'options' => [
                    '0' => 'LC__UNIVERSAL__NO',
                    '1' => 'LC__UNIVERSAL__YES'
                ]
            ]
        ]
    ]);

    // Making the Check_MK controller class available
    $GLOBALS['g_controller']['handler']['check_mk'] = ['class' => 'isys_handler_check_mk'];
    $GLOBALS['g_controller']['handler']['check_mk_export'] = ['class' => 'isys_handler_check_mk_export'];
}
