<?php

/**
 * i-doit
 *
 * Class autoloader.
 *
 * @package     Modules
 * @subpackage  Check_MK
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4.0
 */
class isys_module_check_mk_autoload extends isys_module_manager_autoload
{
    /**
     * Module specific autoloader.
     *
     * @param   string $classname
     *
     * @return  boolean
     * @throws  Exception
     */
    public static function init($classname)
    {
        $base = '/src/classes/modules/check_mk/';

        $classmap = [
            'isys_api_model_checkmk'                    => 'api/isys_api_model_checkmk.class.php',
            'isys_api_model_checkmk_statictag'          => 'api/isys_api_model_checkmk_statictag.class.php',
            'isys_auth_check_mk'                        => 'auth/isys_auth_check_mk.class.php',
            'isys_cmdb_dao_category_g_cmk_host_service' => 'cmdb/dao/global/isys_cmdb_dao_category_g_cmk_host_service.class.php',
            'isys_cmdb_dao_category_g_cmk_service'      => 'cmdb/dao/global/isys_cmdb_dao_category_g_cmk_service.class.php',
            'isys_cmdb_dao_category_g_cmk_tag'          => 'cmdb/dao/global/isys_cmdb_dao_category_g_cmk_tag.class.php',
            'isys_cmdb_dao_list_catg_cmk_host_service'  => 'cmdb/dao/list/isys_cmdb_dao_list_catg_cmk_host_service.class.php',
            'isys_cmdb_dao_list_catg_cmk_service'       => 'cmdb/dao/list/isys_cmdb_dao_list_catg_cmk_service.class.php',
            'isys_cmdb_ui_category_g_cmk'               => 'cmdb/ui/global/isys_cmdb_ui_category_g_cmk.class.php',
            'isys_cmdb_ui_category_g_cmk_host_service'  => 'cmdb/ui/global/isys_cmdb_ui_category_g_cmk_host_service.class.php',
            'isys_cmdb_ui_category_g_cmk_service'       => 'cmdb/ui/global/isys_cmdb_ui_category_g_cmk_service.class.php',
            'isys_cmdb_ui_category_g_cmk_tag'           => 'cmdb/ui/global/isys_cmdb_ui_category_g_cmk_tag.class.php',
            'isys_check_mk_dao'                         => 'dao/isys_check_mk_dao.class.php',
            'isys_check_mk_dao_generic_tag'             => 'dao/isys_check_mk_dao_generic_tag.class.php',
            'isys_ajax_handler_check_mk'                => 'handler/ajax/isys_ajax_handler_check_mk.class.php',
            'isys_handler_check_mk'                     => 'handler/controller/isys_handler_check_mk.class.php',
            'isys_handler_check_mk_export'              => 'handler/controller/isys_handler_check_mk_export.class.php',
            'isys_check_mk_helper'                      => 'helper/isys_check_mk_helper.class.php',
            'isys_check_mk_helper_tag'                  => 'helper/isys_check_mk_helper_tag.class.php',
        ];

        if (isset($classmap[$classname])) {
            if (parent::include_file($base . $classmap[$classname])) {
                isys_caching::factory('autoload')->set($classname, $base . $classmap[$classname]);

                return true;
            }
        }

        return false;
    }
}