<?php

/**
 * i-doit
 *
 * Class autoloader.
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Dennis Stücken <dstuecken@i-doit.com>
 * @version     1.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.2.0
 */
class isys_module_dashboard_autoload extends isys_module_manager_autoload
{
    /**
     * Module specific autoloader.
     *
     * @param   string $p_classname
     *
     * @return  boolean
     * @throws  Exception
     */
    public static function init($p_classname)
    {
        if (strpos($p_classname, 'isys_ajax_handler_dashboard') === 0) {
            $l_path = '/src/classes/modules/dashboard/handler/ajax/' . $p_classname . '.class.php';
        }

        if (strpos($p_classname, 'isys_ajax_handler_dashboard_') === 0) {
            $l_path = '/src/classes/modules/dashboard/handler/ajax/' . str_replace('_', DS, substr($p_classname, 28)) . DS . $p_classname . '.class.php';
        }

        if (strpos($p_classname, 'isys_dashboard_') === 0) {
            $l_path = '/src/classes/modules/dashboard/' . str_replace('_', DS, substr($p_classname, 15)) . DS . $p_classname . '.class.php';
        }

        if ($p_classname === 'isys_auth_dashboard') {
            $l_path = '/src/classes/modules/dashboard/auth/' . $p_classname . '.class.php';
        }

        if (!empty($l_path)) {
            if (parent::include_file($l_path)) {
                isys_caching::factory('autoload')
                    ->add($p_classname, $l_path);

                return true;
            }
        }

        return false;
    }
}