<?php

/**
 * i-doit
 *
 * Class autoloader.
 *
 * @package     modules
 * @subpackage  itservice
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4
 */
class isys_module_itservice_autoload extends isys_module_manager_autoload
{
    /**
     * Module specific autoloader.
     *
     * @param   string $p_classname
     *
     * @return  boolean
     */
    public static function init($p_classname)
    {
        if (strpos($p_classname, 'isys_ajax_handler_itservice') === 0) {
            $l_path = '/src/classes/modules/itservice/handler/ajax/' . $p_classname . '.class.php';
        } else if (strpos($p_classname, 'isys_itservice_dao_') === 0) {
            $l_path = '/src/classes/modules/itservice/dao/' . $p_classname . '.class.php';
        } else if (strpos($p_classname, 'isys_itservice_reports') === 0) {
            $l_path = '/src/classes/modules/itservice/reports/' . $p_classname . '.class.php';
        } else if ($p_classname === 'isys_auth_itservice') {
            $l_path = '/src/classes/modules/itservice/auth/' . $p_classname . '.class.php';
        } else if ($p_classname === 'isys_cmdb_dao_list_objects_it_service') {
            $l_path = '/src/classes/modules/itservice/dao/' . $p_classname . '.class.php';
        } else if (strpos($p_classname, 'isys_itservice_') === 0) {
            $l_path = '/src/classes/modules/itservice/' . str_replace('_', DS, substr($p_classname, 15)) . DS . $p_classname . '.class.php';
        }

        if (!empty($l_path)) {
            if (parent::include_file($l_path)) {
                isys_caching::factory('autoload')
                    ->set($p_classname, $l_path);

                return true;
            }
        }

        return false;
    }
}