<?php

/**
 * i-doit
 *
 * CMDB UI: specific category for enclosures.
 *
 * @package     i-doit
 * @subpackage  CMDB_Categories
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_cmdb_ui_category_s_enclosure extends isys_cmdb_ui_category_specific
{
    /**
     * Shows the detailed template. Dies after an AJAX request.
     *
     * @param  isys_cmdb_dao_category $p_cat
     *
     * @return array
     */
    public function process(isys_cmdb_dao_category $p_cat)
    {
        isys_component_template_navbar::getInstance()
            ->set_visible(false, C__NAVBAR_BUTTON__PRINT);

        $l_object_id = $p_cat->get_object_id();

        $l_rack_height = 0;
        $l_templates = [];
        $l_objects = [];
        $l_rules = [];
        $l_height_units = [];

        // Get description:
        $l_catdata = $p_cat->get_general_data();

        $this->fill_formfields($p_cat, $l_rules, $l_catdata);

        if ($l_object_id > 0) {
            $l_rack_height = (int)isys_cmdb_dao_category_g_formfactor::instance($this->get_database_component())
                ->get_data(null, $l_object_id)
                ->get_row_value('isys_catg_formfactor_list__rackunits');

            $l_objects = $p_cat->prepare_rack_data($l_object_id, $l_catdata['isys_obj__title'])['objects'];

            if ($l_rack_height > 0) {
                for ($i = 1;$i <= $l_rack_height;$i++) {
                    $l_height_units[$i] = $i . ' ' . isys_application::instance()->container->get('language')
                            ->get('LC__CMDB__CATG__RACKUNITS_ABBR');
                }
            }

            $l_segment_object_type = isys_tenantsettings::get('cmdb.rack.segment-template-object-type', 'C__OBJTYPE__RACK_SEGMENT');

            if (!defined($l_segment_object_type)) {
                isys_notify::warning(isys_application::instance()->container->get('language')
                        ->get('LC__CMDB__CATS__RACK__OBJECT_TYPE_DOES_NOT_EXIST') . ' (' . $l_segment_object_type . ')', ['life' => 10]);
            } else {
                $l_template_res = $p_cat->get_objects_by_type(constant($l_segment_object_type), C__RECORD_STATUS__TEMPLATE);

                if (!count($l_template_res)) {
                    isys_notify::warning(isys_application::instance()->container->get('language')
                        ->get('LC__CMDB__CATS__RACK__NO_TEMPLATE_OBJECTS'), ['life' => 10]);
                } else {
                    while ($l_template_row = $l_template_res->get_row()) {
                        $l_templates[$l_template_row['isys_obj__id']] = $l_template_row['isys_obj__title'];
                    }
                }
            }
        }

        $l_rules['C__CATS__ENCLOSURE__SEGMENT_TEMPLATES']['p_strClass'] = 'input-block';
        $l_rules['C__CATS__ENCLOSURE__SEGMENT_TEMPLATES']['p_arData'] = $l_templates;
        $l_rules['C__CATS__ENCLOSURE__SEGMENT_TEMPLATES']['p_bEditMode'] = true;
        $l_rules['C__CATS__ENCLOSURE__SEGMENT_TEMPLATES']['p_bDbFieldNN'] = true;
        $l_rules['C__CATS__ENCLOSURE__SEGMENT_TEMPLATES']['p_bInfoIconSpacer'] = 0;
        $l_rules['C__CATS__ENCLOSURE__UNIT_SORTING']['p_strSelectedID'] = $l_catdata['isys_cats_enclosure_list__slot_sorting'];
        $l_rules['C__CATS__ENCLOSURE__UNIT_SORTING']['p_arData'] = [
            'asc'  => isys_application::instance()->container->get('language')
                ->get('LC__CMDB__SORTING__ASC'),
            'desc' => isys_application::instance()->container->get('language')
                ->get('LC__CMDB__SORTING__DESC')
        ];
        $l_rules['C__CATS__ENCLOSURE__VERTICAL_SLOTS_FRONT']['p_strSelectedID'] = $l_catdata['isys_cats_enclosure_list__vertical_slots_front'];
        $l_rules['C__CATS__ENCLOSURE__VERTICAL_SLOTS_FRONT']['p_arData'] = range(0, isys_cmdb_dao_category_s_enclosure::C__RACK__VERTICAL_SLOTS);
        $l_rules['C__CATS__ENCLOSURE__VERTICAL_SLOTS_FRONT']['p_bSort'] = false;
        $l_rules['C__CATS__ENCLOSURE__VERTICAL_SLOTS_REAR']['p_strSelectedID'] = $l_catdata['isys_cats_enclosure_list__vertical_slots_rear'];
        $l_rules['C__CATS__ENCLOSURE__VERTICAL_SLOTS_REAR']['p_arData'] = range(0, isys_cmdb_dao_category_s_enclosure::C__RACK__VERTICAL_SLOTS);
        $l_rules['C__CATS__ENCLOSURE__VERTICAL_SLOTS_REAR']['p_bSort'] = false;
        $l_rules['C__CATS__ENCLOSURE__HE_UNIT']['p_arData'] = $l_height_units;
        $l_rules['C__CATS__ENCLOSURE__HE_UNIT']['p_strClass'] = 'input-block';
        $l_rules['C__CATS__ENCLOSURE__HE_UNIT']['p_bEditMode'] = 1;
        $l_rules['C__CATS__ENCLOSURE__HE_UNIT']['p_bSort'] = false;
        $l_rules['C__CATS__ENCLOSURE__HE_UNIT']['disableInputGroup'] = true;
        $l_rules['C__CATS__ENCLOSURE__HE_UNIT']['p_bDbFieldNN'] = true;
        $l_rules['C__CATS__ENCLOSURE__HE_UNIT']['p_bInfoIconSpacer'] = 0;

        $l_rules['C__CMDB__CAT__COMMENTARY_' . $p_cat->get_category_type() . $p_cat->get_category_id()]['p_strValue'] = $l_catdata['isys_cats_enclosure_list__description'];

        // Preparing the link to the category for attach- and detaching objects.
        $l_link = isys_helper_link::create_url([
            C__CMDB__GET__OBJECT   => $l_object_id,
            C__CMDB__GET__CATG     => C__CATG__OBJECT,
            C__CMDB__GET__VIEWMODE => C__CMDB__VIEW__LIST_CATEGORY,
            C__CMDB__GET__TREEMODE => C__CMDB__VIEW__TREE_OBJECT
        ]);

        // Assign the variables to the template.
        $this->get_template_component()
            ->assign('has_edit_right', isys_auth_cmdb::instance()
                ->has_rights_in_obj_and_category(isys_auth::EDIT, $l_object_id, 'C__CATS__ENCLOSURE'))
            ->assign('new_entry', !isset($l_catdata['isys_cats_enclosure_list__slot_sorting']))
            ->assign('category_link', $l_link)
            ->assign('object_id', $l_object_id)
            ->assign('objects', array_values($l_objects))
            ->assign('rack_slots', $l_rack_height)
            ->assign('rack_slot_sorting', $l_catdata['isys_cats_enclosure_list__slot_sorting'])
            ->assign('vertical_slots_front', $l_catdata['isys_cats_enclosure_list__vertical_slots_front'])
            ->assign('vertical_slots_rear', $l_catdata['isys_cats_enclosure_list__vertical_slots_rear'])
            ->smarty_tom_add_rules('tom.content.bottom.content', $l_rules);

        return $l_rules;
    }
}
