<?php

/**
 * i-doit
 * Class autoloader.
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Dennis Stücken <dstuecken@i-doit.com>
 * @version     1.1
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_module_quick_configuration_wizard_autoload extends isys_module_manager_autoload
{
    /**
     * Module specific autoloader.
     *
     * @param   string $p_classname
     *
     * @return  boolean
     */
    public static function init($p_classname)
    {
        $l_classlist = [
            'isys_ajax_handler_quick_configuration_wizard' => '/src/classes/modules/quick_configuration_wizard/ajax/isys_ajax_handler_quick_configuration_wizard.class.php',
            'isys_quick_configuration_wizard_dao'          => '/src/classes/modules/quick_configuration_wizard/dao/isys_quick_configuration_wizard_dao.class.php',
            'isys_popup_qcw_adjust'                        => '/src/classes/modules/quick_configuration_wizard/src/popup/isys_popup_qcw_adjust.class.php',
            'isys_popup_qcw_adjust_category'               => '/src/classes/modules/quick_configuration_wizard/src/popup/isys_popup_qcw_adjust_category.class.php',
            'isys_popup_qcw_adjust_object_type'            => '/src/classes/modules/quick_configuration_wizard/src/popup/isys_popup_qcw_adjust_object_type.class.php',
            'isys_popup_qcw_adjust_object_type_group'      => '/src/classes/modules/quick_configuration_wizard/src/popup/isys_popup_qcw_adjust_object_type_group.class.php',
            'isys_popup_qcw_profiles'                      => '/src/classes/modules/quick_configuration_wizard/src/popup/isys_popup_qcw_profiles.class.php',
        ];

        if (isset($l_classlist[$p_classname])) {
            if (parent::include_file($l_classlist[$p_classname])) {
                isys_caching::factory('autoload')
                    ->set($p_classname, $l_classlist[$p_classname]);

                return true;
            }
        }

        return false;
    }
}