<?php
/**
 * i-doit
 *
 * Module initializer
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Dennis Stücken <dstuecken@i-doit.com>
 * @version     1.5.3
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

if (include_once('isys_module_search_autoload.class.php')) {
    spl_autoload_register('isys_module_search_autoload::init');
}

\idoit\Psr4AutoloaderClass::factory()
    ->addNamespace('idoit\Module\Search', __DIR__ . '/src/');

isys_application::instance()->container->get('language')
    ->append_lang_file(__DIR__ . '/lang/' . isys_component_session::instance()
            ->get_language() . '.inc.php');

isys_tenantsettings::extend([
    isys_application::instance()->container->get('language')
        ->get('LC__UNIVERSAL__SEARCH') => [
        'defaults.search.mode'                => [
            'title'       => isys_application::instance()->container->get('language')
                ->get('LC__SEARCH__CONFIG__MODE'),
            'type'        => 'select',
            'options'     => \idoit\Module\Search\Query\Condition::$modes,
            'description' => isys_application::instance()->container->get('language')
                    ->get('LC__SEARCH__CONFIG__SUGGESTION_NOTE') . '<br /><br />' . isys_application::instance()->container->get('language')
                    ->get('LC__SEARCH__CONFIG__NORMAL_DESCRIPTION') . '<br /><br />' . isys_application::instance()->container->get('language')
                    ->get('LC__SEARCH__CONFIG__DEEP_DESCRIPTION'),
            'default'     => '0',
        ],
        'search.global.autostart-deep-search' => [
            'title'       => isys_application::instance()->container->get('language')
                ->get('LC__SEARCH__CONFIG__AUTOMATIC_DEEP_SEARCH'),
            'type'        => 'select',
            'options'     => [
                isys_module_search::AUTOMATIC_DEEP_SEARCH_ACTIVE              => isys_application::instance()->container->get('language')
                    ->get('LC__SEARCH__CONFIG__AUTOMATIC_DEEP_SEARCH_ACTIVE'),
                isys_module_search::AUTOMATIC_DEEP_SEARCH_ACTIVE_EMPTY_RESULT => isys_application::instance()->container->get('language')
                    ->get('LC__SEARCH__CONFIG__AUTOMATIC_DEEP_SEARCH_ACTIVE_EMPTY_RESULT'),
                isys_module_search::AUTOMATIC_DEEP_SEARCH_NONACTIVE           => isys_application::instance()->container->get('language')
                    ->get('LC__SEARCH__CONFIG__AUTOMATIC_DEEP_SEARCH_NONACTIVE')
            ],
            'description' => isys_application::instance()->container->get('language')
                ->get('LC__SEARCH__CONFIG__AUTOMATIC_DEEP_SEARCH_DESCRIPTION'),
            'default'     => isys_module_search::AUTOMATIC_DEEP_SEARCH_NONACTIVE
        ],
        'search.highlight-search-string'      => [
            'title'       => isys_application::instance()->container->get('language')
                ->get('LC__SEARCH__CONFIG__HIGHLIGHTING_OPTION'),
            'type'        => 'select',
            'options'     => get_smarty_arr_YES_NO(),
            'description' => isys_application::instance()->container->get('language')
                ->get('LC__SEARCH__CONFIG__HIGHLIGHTING_OPTION_DESCRIPTION'),
            'default'     => '1',
        ],
        'search.minlength.search-string'      => [
            'title'       => 'LC__SEARCH__CONFIG__MINLENGTH_SEARCHSTRING',
            'description' => 'LC__SEARCH__CONFIG__MINLENGTH_SEARCHSTRING_DESCRIPTION',
            'type'        => 'int',
            'placeholder' => 3,
            'default'     => 3
        ],
        'search.index.include_archived_deleted_objects' => [
            'title'       => isys_application::instance()->container->get('language')
                ->get('LC__SEARCH__CONFIG__INDEX__INCLUDE_ARCHIVED_DELETED_OBJECTS'),
            'type'        => 'select',
            'options'     => get_smarty_arr_YES_NO(),
            'description' => isys_application::instance()->container->get('language')
                ->get('LC__SEARCH__CONFIG__INDEX__INCLUDE_ARCHIVED_DELETED_OBJECTS__DESCRIPTION'),
            'default'     => '0',
        ],
        'search.index.location_paths' => [
            'title'       => isys_application::instance()->container->get('language')
                ->get('LC__SEARCH__CONFIG__INDEX__LOCATION_PATHS'),
            'type'        => 'select',
            'options'     => get_smarty_arr_YES_NO(),
            'description' => isys_application::instance()->container->get('language')
                ->get('LC__SEARCH__CONFIG__INDEX__LOCATION_PATHS__DESCRIPTION'),
            'default'     => '0',
        ]
    ]
]);
