<?php

/**
 * i-doit Report Manager.
 *
 * @package     i-doit
 * @subpackage  Reports
 * @author      Dennis Bluemer <dbluemer@synetics.de>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_report_csv extends isys_report
{
    /**
     * Define the content-type.
     *
     * @var  string
     */
    private $m_contentType = "text/x-csv";

    /**
     * Define the file extension.
     *
     * @var  string
     */
    private $m_fileExtension = "csv";

    /**
     * Content-type getter.
     *
     * @return  string
     */
    public function getContentType()
    {
        return $this->m_contentType;
    }

    /**
     * This method will export the report to the desired format.
     *
     * @throws  Exception
     */
    public function export()
    {
        try {
            if (self::$m_as_download) {
                $this->output($this->toString());
            } else {
                $this->set_export_output(chr(239) . chr(187) . chr(191) . $this->toString());
            }
        } catch (Exception $e) {
            throw new Exception($e->getMessage());
        }

    }

    /**
     * Transfers the export string to the client with the given content-type information.
     *
     * @param  string $p_data
     */
    protected function output($p_data)
    {
        // Strip every "not-word" character.
        $l_title = strtolower(preg_replace("/\W+/", "_", $this->getTitle()));

        header("Content-Type: " . $this->m_contentType);
        header("Expires: " . date("D, d M Y H:i:s") . " GMT");
        header("Content-Disposition: attachment; filename=" . date("ymd") . "-idoit-report-" . $l_title . "." . $this->m_fileExtension);
        header("Pragma: no-cache");

        // This solves the problem with Umlauts in excel
        echo chr(239) . chr(187) . chr(191) . $p_data;
        die;
    }

    /**
     * Returns the report as a csv-String.
     *
     * @throws  Exception
     * @return  string
     */
    protected function toString()
    {
        $l_report = $this->query(true, false);

        $l_csv = "";

        if (is_array($l_report["headers"])) {
            foreach ($l_report["headers"] as $l_value) {
                $l_csv .= '"' . str_replace("\n", "", $l_value) . '";';
            }

            $l_csv .= CRLF;
        } else {
            throw new Exception("Error processing report headers");
        }

        if (is_array($l_report["content"])) {
            foreach ($l_report["content"] as $l_data) {
                if (is_array($l_data)) {
                    foreach ($l_data as $l_table => $l_value) {
                        // Replace <script>-Tags with content generated by QuickInfo-Tooltips.
                        $l_value = preg_replace('/<script[^>]*>[^<]*<[^>]script>/  ', '', $l_value);

                        $l_value = strip_tags(str_replace('"', '\'', $l_value));
                        if (!preg_match("/^__[\w]+__$/i", $l_table)) {
                            $l_csv .= '"' . isys_application::instance()->container->get('language')
                                    ->get($l_value) . '";';
                        }
                    }

                    $l_csv .= CRLF;
                }
            }
        }

        return $l_csv;
    }
}
