<?php
/**
 * i-doit Module interface for installation
 *
 * @package     idoit\Component
 * @author      atsapko
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

namespace idoit\AddOn;

interface InstallableInterface
{
    /**
     * Checks if a module is installed.
     *
     * @return integer|bool
     */
    public static function isInstalled();

    /**
     * Basic installation process for all mandators
     */
    public static function install();

    /**
     * Uninstall module for all mandators
     */
    public static function uninstall();
}