<?php

namespace idoit\Component\Browser\Condition;

use idoit\Component\Browser\Condition;
use idoit\Component\Browser\ConditionInterface;
use isys_application;

class RelationTypeCondition extends Condition implements ConditionInterface
{
    const OBJECT_LIMIT   = 5000;

    /**
     * @inheritdoc
     */
    public function retrieveOverview()
    {
        $language = isys_application::instance()->container->get('language');
        $overview = [];

        $sql = 'SELECT isys_relation_type__id AS id, isys_relation_type__title AS title 
            FROM isys_relation_type
			INNER JOIN isys_catg_relation_list ON isys_catg_relation_list__id = isys_catg_relation_list__isys_relation_type__id
			INNER JOIN isys_obj ON isys_obj__id = isys_catg_relation_list__isys_obj__id
            INNER JOIN isys_obj_type ON isys_obj_type__id = isys_obj__isys_obj_type__id
            WHERE isys_relation_type__status = ' . $this->dao->convert_sql_int(C__RECORD_STATUS__NORMAL) .
            $this->getFilterQueryConditions() . '
            GROUP BY isys_relation_type__id;';

        $result = $this->dao->retrieve($sql);

        while ($row = $result->get_row()) {
            // @see  ID-5613  Due to performance issues with bigger installations, we need to count separately.
            $countSql = 'SELECT COUNT(isys_catg_relation_list__id) AS cnt FROM (SELECT isys_catg_relation_list__id
                FROM isys_catg_relation_list
                INNER JOIN isys_obj ON isys_obj__id = isys_catg_relation_list__isys_obj__id
                INNER JOIN isys_obj_type ON isys_obj_type__id = isys_obj__isys_obj_type__id
                WHERE isys_catg_relation_list__isys_relation_type__id = ' . $this->dao->convert_sql_id($row['id']) . ' 
                AND isys_obj__status = ' . $this->dao->convert_sql_int(C__RECORD_STATUS__NORMAL) . $this->getFilterQueryConditions() . '
                LIMIT ' . self::OBJECT_LIMIT . ') AS innerCount;';

            $count = $this->dao->retrieve($countSql)->get_row_value('cnt');

            if ($count) {
                // @see  ID-5613  When exceeding the limit (for example "5000"), simply display a string like "+4999".
                $overview[$row['id']] = $language->get($row['title']) . ' (' . ($count >= self::OBJECT_LIMIT ? '+' . (self::OBJECT_LIMIT - 1) : $count) . ')';
            }
        }

        natcasesort($overview);

        return $overview;
    }

    /**
     * @inheritdoc
     */
    public function retrieveObjects()
    {
        $return = [];

        $sql = 'SELECT isys_obj__id AS id
            FROM isys_obj 
            INNER JOIN isys_catg_relation_list ON isys_catg_relation_list__isys_obj__id = isys_obj__id
            INNER JOIN isys_obj_type ON isys_obj_type__id = isys_obj__isys_obj_type__id
            WHERE isys_catg_relation_list__isys_relation_type__id = ' . $this->dao->convert_sql_id($this->parameter) . '
            AND isys_obj__status = ' . $this->dao->convert_sql_int(C__RECORD_STATUS__NORMAL) .
            $this->getFilterQueryConditions() . ';';

        $result = $this->dao->retrieve($sql);

        while ($row = $result->get_row()) {
            $return[] = $row['id'];
        }

        return $return;
    }
}