<?php

namespace idoit\Component\Browser\Filter;

use idoit\Component\Browser\Filter;
use idoit\Component\Browser\FilterInterface;

class CmdbStatusFilter extends Filter implements FilterInterface
{
    /**
     * Method for retrieving a CMDB-Status query condition by a provided parameter.
     *
     * @return string
     */
    public function getQueryCondition()
    {
        if (count($this->parameter)) {
            return ' AND isys_obj__isys_cmdb_status__id ' . $this->dao->prepare_in_condition($this->parameter) . ' ';
        }

        return '';
    }
}