<?php

namespace idoit\Component\Browser\Filter;

use idoit\Component\Browser\Filter;
use idoit\Component\Browser\FilterInterface;

class ObjectTypeFilter extends Filter implements FilterInterface
{
    /**
     * Method for retrieving a object type query condition by a provided parameter.
     *
     * @return string
     */
    public function getQueryCondition()
    {
        if (count($this->parameter)) {
            return ' AND isys_obj_type__id ' . $this->dao->prepare_in_condition($this->parameter) . ' ';
        }

        return '';
    }
}