<?php

namespace idoit\Component\Browser\Filter;

use idoit\Component\Browser\Filter;
use idoit\Component\Browser\FilterInterface;

class SpecificCategoryFilter extends Filter implements FilterInterface
{
    /**
     * Method for retrieving a specific category query condition by a provided parameter.
     *
     * @return string
     */
    public function getQueryCondition()
    {
        if (count($this->parameter)) {
            return ' AND isys_obj_type__isysgui_cats__id ' . $this->dao->prepare_in_condition($this->parameter) . ' ';
        }

        return '';
    }
}