<?php
/**
 *
 *
 * @package     i-doit
 * @subpackage
 * @author      Pavel Abduramanov <pabduramanov@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

namespace idoit\Component\Table\Filter\Operation;

use isys_cmdb_dao_category;
use isys_cmdb_dao_list_objects;

/**
 * Operation, that uses property
 *
 * @package idoit\Component\Table\Filter\Operation
 */
abstract class PropertyOperation extends Operation
{
    protected function getProperty($name)
    {
        global $g_comp_database;
        try {
            list($class, $prop) = explode('__', $name);
            if (class_exists($class) && is_subclass_of($class, 'isys_cmdb_dao_category')) {
                $dao = new $class($g_comp_database);
                if (!$dao instanceof isys_cmdb_dao_category) {
                    return false;
                }

                return $dao->get_property_by_key($prop);
            }
        } catch (\Exception $e) {}
        return null;
    }

    protected function applyFormatted(isys_cmdb_dao_list_objects $listDao, $name, $value)
    {
        $property = $this->getProperty($name);

        if (!$property) {
            return false;
        }

        return $this->applyProperty($listDao, $property, $name, $value);
    }

    /**
     * Apply Property
     *
     * @param isys_cmdb_dao_list_objects $listDao
     * @param                            $property
     * @param                            $name
     * @param                            $value
     *
     * @return mixed
     */
    abstract protected function applyProperty(isys_cmdb_dao_list_objects $listDao, $property, $name, $value);
}
