<?php
/**
 * i-doit - Updates
 *
 * Migrating values in "power_consumer" and "power_supplier" to float values.
 *
 * @package     i-doit
 * @subpackage  Update
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @author      Leonard Fischer <lfischer@i-doit.com>
 */

/**
 * @var $g_comp_database isys_component_database
 */
global $g_comp_database;

$g_migration_identifier = "category_constant_migration";

if ($this->is_migration_done($g_migration_identifier)) {
    $g_migration_log[] = '<span class="bold">Category constant migration has already been done.</span>';
} else {
    $g_migration_log[] = '<span class="bold">Startin category constant migration.</span>';

    $dao = isys_cmdb_dao::instance($g_comp_database);

    $affectedTables = [
        'isys_document_component'             => ['isys_document_component__text'],
        'isys_document_template'              => ['isys_document_template__index', 'isys_document_template__header', 'isys_document_template__footer'],
        'isys_analytics_dataquality_profiles' => ['isys_analytics_dataquality_profiles__data'],
    ];

    $categoryConstantMatching = [
        'C__CMDB__SUBCAT__NETWORK_PORT'                      => 'C__CATG__NETWORK_PORT',
        'C__CMDB__SUBCAT__NETWORK_INTERFACE_P'               => 'C__CATG__NETWORK_INTERFACE',
        'C__CMDB__SUBCAT__NETWORK_INTERFACE_L'               => 'C__CATG__NETWORK_LOG_PORT',
        'C__CMDB__SUBCAT__NETWORK_PORT_OVERVIEW'             => 'C__CATG__NETWORK_PORT_OVERVIEW',
        'C__CMDB__SUBCAT__STORAGE__DEVICE'                   => 'C__CATG__STORAGE_DEVICE',
        'C__CMDB__SUBCAT__LICENCE_LIST'                      => 'C__CATS__LICENCE_LIST',
        'C__CMDB__SUBCAT__LICENCE_OVERVIEW'                  => 'C__CATS__LICENCE_OVERVIEW',
        'C__CMDB__SUBCAT__EMERGENCY_PLAN_LINKED_OBJECT_LIST' => 'C__CATS__EMERGENCY_PLAN_LINKED_OBJECTS',
        'C__CMDB__SUBCAT__EMERGENCY_PLAN'                    => 'C__CATS__EMERGENCY_PLAN_ATTRIBUTE',
        'C__CMDB__SUBCAT__WS_NET_TYPE'                       => 'C__CATS__WS_NET_TYPE',
        'C__CMDB__SUBCAT__WS_ASSIGNMENT'                     => 'C__CATS__WS_ASSIGNMENT',
        'C__CMDB__SUBCAT__FILE_OBJECTS'                      => 'C__CATS__FILE_OBJECTS',
        'C__CMDB__SUBCAT__FILE_VERSIONS'                     => 'C__CATS__FILE_VERSIONS',
        'C__CMDB__SUBCAT__FILE_ACTUAL'                       => 'C__CATS__FILE_ACTUAL'
    ];

    foreach ($affectedTables as $table => $columns) {
        if (!$dao->table_exists($table)) {
            continue;
        }

        $success = 0;

        foreach ($columns as $column) {
            foreach ($categoryConstantMatching as $oldConstant => $newConstant) {
                $sql = 'SELECT COUNT(*) AS cnt
                    FROM ' . $table . '
                    WHERE ' . $column . ' LIKE "%' . $oldConstant . '%";';

                try {
                    if ($dao->retrieve($sql)->get_row_value('cnt')) {
                        $updateQuery = "UPDATE " . $table . "
                            SET " . $column . " = REPLACE(" . $column . ", '" . $oldConstant . "', '" . $newConstant . "')
                            WHERE " . $column . " LIKE '%" . $oldConstant . "%';";

                        $dao->update($updateQuery) && $dao->apply_update();

                        $success ++;
                    }
                } catch (Exception $e) {
                    $g_migration_log[] = '<span class="indent red bold">Error: ' . $e->getMessage() . '</span>';
                }
            }
        }

        if ($success > 0) {
            $g_migration_log[] = '<span class="indent green bold">Migrated ' . $success . ' entries in table "' . $table . '"</span>';
        }
    }

    $g_migration_log[] = '<span class="bold">Finished migration!</span>';

    $this->migration_done($g_migration_identifier);
}
