<?php

use idoit\Console\IdoitConsoleApplication;
use idoit\Module\Workflow\Console\Command\HandleWorkflowsCommand;
use Symfony\Component\Console\Input\ArrayInput;
use Symfony\Component\Console\Output\ConsoleOutput;

/**
 * i-doit
 *
 * Workflow handler
 *
 * @package    i-doit
 * @subpackage General
 * @author     Dennis Stücken <dstuecken@i-doit.de>
 * @version    1.0
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 *
 * @deprecated Use HandleWorkflowsCommand instead
 */
class isys_handler_workflow extends isys_handler
{
    /**
     * @var  mixed
     */
    private $m_workflow_type = [HandleWorkflowsCommand::DEFAULT_WORKFLOW_TYPE];

    /**
     * @return bool
     */
    public function init()
    {
        global $g_comp_session, $argv;

        if (in_array('-t', $argv)) {
            $l_type_key = array_search('-t', $argv) + 1;
            if (isset($argv[$l_type_key])) {
                $l_type = $argv[$l_type_key];
                if (strpos($l_type, ',') > 0) {
                    $this->m_workflow_type = explode(',', $l_type);
                } else {
                    $this->m_workflow_type = [$l_type];
                }
            } else {
                $this->m_workflow_type = ['checklist'];
            }
        }

        $application = new IdoitConsoleApplication();
        $application->setAutoExit(false);

        $output = new ConsoleOutput();

        $output->writeln('<error>isys_handler_workflow is deprecated, please use php console.php workflows-process instead</error>');

        $commandParams = [
            'command'    => 'workflows-process',
            '--types'    => $this->m_workflow_type,
            '--user'     => 'loginBefore',
            '--password' => 'loginBefore',
            '--tenantId' => 'loginBefore'
        ];

        if (in_array('-h', $argv)) {
            $commandParams['--help'] = true;
        }

        /**
         * @var $command \idoit\Console\Command\AbstractCommand
         */
        $command = new HandleWorkflowsCommand();
        $command->setSession($g_comp_session);
        $command->setContainer(\isys_application::instance()->container);
        $command->setAuth(\isys_auth_workflow::instance());

        $application->add($command);

        $application->run(new ArrayInput($commandParams), $output);
    }
}
