<?php

/**
 * i-doit
 *
 * Class autoloader.
 *
 * @package     Modules
 * @subpackage  Nagios
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_module_nagios_autoload extends isys_module_manager_autoload
{
    /**
     * Module specific autoloader.
     *
     * @param   string $className
     *
     * @return  boolean
     */
    public static function init($className)
    {
        $addOnPath = '/src/classes/modules/nagios/';
        $classMap = [
            'isys_api_model_console_nagios.class.php'                    => 'api/isys_api_model_console_nagios.class.php',
            'isys_handler_nagios_export'                                 => 'handler/controller/isys_handler_nagios_export.class.php',
            'isys_handler_nagios'                                        => 'handler/controller/isys_handler_nagios.class.php',
            'isys_ajax_handler_nagios'                                   => 'handler/ajax/isys_ajax_handler_nagios.class.php',
            'isys_auth_nagios'                                           => 'auth/isys_auth_nagios.class.php',
            'isys_module_nagios'                                         => 'isys_module_nagios.class.php',
            'isys_module_nagios_autoload'                                => 'isys_module_nagios_autoload.class.php',
            'isys_component_dao_nagios'                                  => 'component/isys_component_dao_nagios.class.php',
            'isys_nagios_export'                                         => 'export/isys_nagios_export.class.php',
            'isys_export_helper_nagios'                                  => 'export/isys_export_helper_nagios.class.php',
            'isys_nagios_helper'                                         => 'helper/isys_nagios_helper.class.php',
            'isys_cmdb_ui_category_s_person_nagios'                      => 'cmdb/ui/specific/isys_cmdb_ui_category_s_person_nagios.class.php',
            'isys_cmdb_ui_category_s_person_group_nagios'                => 'cmdb/ui/specific/isys_cmdb_ui_category_s_person_group_nagios.class.php',
            'isys_cmdb_ui_category_g_nagios_refs_services'               => 'cmdb/ui/global/isys_cmdb_ui_category_g_nagios_refs_services.class.php',
            'isys_cmdb_ui_category_g_nagios_service_tpl_def'             => 'cmdb/ui/global/isys_cmdb_ui_category_g_nagios_service_tpl_def.class.php',
            'isys_cmdb_ui_category_g_nagios_service_dep'                 => 'cmdb/ui/global/isys_cmdb_ui_category_g_nagios_service_dep.class.php',
            'isys_cmdb_ui_category_g_nagios_host_tpl_assigned_objects'   => 'cmdb/ui/global/isys_cmdb_ui_category_g_nagios_host_tpl_assigned_objects.class.php',
            'isys_cmdb_ui_category_g_nagios'                             => 'cmdb/ui/global/isys_cmdb_ui_category_g_nagios.class.php',
            'isys_cmdb_ui_category_g_nagios_group'                       => 'cmdb/ui/global/isys_cmdb_ui_category_g_nagios_group.class.php',
            'isys_cmdb_ui_category_g_nagios_refs_services_backwards'     => 'cmdb/ui/global/isys_cmdb_ui_category_g_nagios_refs_services_backwards.class.php',
            'isys_cmdb_ui_category_g_nagios_host_tpl_def'                => 'cmdb/ui/global/isys_cmdb_ui_category_g_nagios_host_tpl_def.class.php',
            'isys_cmdb_ui_category_g_nagios_service_refs_tpl_backwards'  => 'cmdb/ui/global/isys_cmdb_ui_category_g_nagios_service_refs_tpl_backwards.class.php',
            'isys_cmdb_ui_category_g_nagios_service_def'                 => 'cmdb/ui/global/isys_cmdb_ui_category_g_nagios_service_def.class.php',
            'isys_cmdb_dao_category_s_person_nagios'                     => 'cmdb/dao/category/specific/isys_cmdb_dao_category_s_person_nagios.class.php',
            'isys_cmdb_dao_category_s_person_group_nagios'               => 'cmdb/dao/category/specific/isys_cmdb_dao_category_s_person_group_nagios.class.php',
            'isys_cmdb_dao_category_g_nagios_refs_services_backwards'    => 'cmdb/dao/category/global/isys_cmdb_dao_category_g_nagios_refs_services_backwards.class.php',
            'isys_cmdb_dao_category_g_nagios_service_refs_tpl_backwards' => 'cmdb/dao/category/global/isys_cmdb_dao_category_g_nagios_service_refs_tpl_backwards.class.php',
            'isys_cmdb_dao_category_g_nagios_group'                      => 'cmdb/dao/category/global/isys_cmdb_dao_category_g_nagios_group.class.php',
            'isys_cmdb_dao_category_g_nagios_service_dep'                => 'cmdb/dao/category/global/isys_cmdb_dao_category_g_nagios_service_dep.class.php',
            'isys_cmdb_dao_category_g_nagios_host_tpl_assigned_objects'  => 'cmdb/dao/category/global/isys_cmdb_dao_category_g_nagios_host_tpl_assigned_objects.class.php',
            'isys_cmdb_dao_category_g_nagios_service_def'                => 'cmdb/dao/category/global/isys_cmdb_dao_category_g_nagios_service_def.class.php',
            'isys_cmdb_dao_category_g_nagios_refs_services'              => 'cmdb/dao/category/global/isys_cmdb_dao_category_g_nagios_refs_services.class.php',
            'isys_cmdb_dao_category_g_nagios'                            => 'cmdb/dao/category/global/isys_cmdb_dao_category_g_nagios.class.php',
            'isys_cmdb_dao_category_g_nagios_host_tpl_def'               => 'cmdb/dao/category/global/isys_cmdb_dao_category_g_nagios_host_tpl_def.class.php',
            'isys_cmdb_dao_category_g_nagios_service_tpl_def'            => 'cmdb/dao/category/global/isys_cmdb_dao_category_g_nagios_service_tpl_def.class.php',
            'isys_cmdb_dao_list_catg_nagios_service_dep'                 => 'cmdb/dao/list/isys_cmdb_dao_list_catg_nagios_service_dep.class.php',
            'isys_cmdb_dao_list_catg_nagios_service_refs_tpl_backwards'  => 'cmdb/dao/list/isys_cmdb_dao_list_catg_nagios_service_refs_tpl_backwards.class.php',
            'isys_cmdb_dao_list_catg_nagios_refs_services'               => 'cmdb/dao/list/isys_cmdb_dao_list_catg_nagios_refs_services.class.php',
            'isys_cmdb_dao_list_catg_nagios_host_tpl_assigned_objects'   => 'cmdb/dao/list/isys_cmdb_dao_list_catg_nagios_host_tpl_assigned_objects.class.php',
            'isys_cmdb_dao_list_catg_nagios_refs_services_backwards'     => 'cmdb/dao/list/isys_cmdb_dao_list_catg_nagios_refs_services_backwards.class.php',
        ];

        if (isset($classMap[$className]) && parent::include_file($addOnPath . $classMap[$className])) {
            isys_cache::keyvalue()
                ->ns('autoload')
                ->set($className, $addOnPath . $classMap[$className]);

            return true;
        }

        return false;
    }
}
