<?php

/**
 * i-doit
 *
 * UI: global category for Check_MK.
 *
 * @package     Modules
 * @subpackage  Check_MK
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.4.0
 */
class isys_cmdb_ui_category_g_cmk extends isys_cmdb_ui_category_global
{
    /**
     * Processes the UI for the category check_mk.
     *
     * @param isys_cmdb_dao_category $p_cat
     *
     * @return  void
     * @throws Exception
     * @author  Leonard Fischer <lfischer@i-doit.com>
     */
    public function process(isys_cmdb_dao_category $p_cat)
    {
        $l_rules = [];
        $l_obj_id = $_GET[C__CMDB__GET__OBJECT];
        $l_catdata = $p_cat->get_general_data();

        $this->fill_formfields($p_cat, $l_rules, $l_catdata);

        // Preparing the host-name selection
        $l_prim_ip = isys_cmdb_dao_category_g_ip::instance($this->m_database_component)
            ->get_primary_ip($l_obj_id)
            ->get_row();

        if (!empty($l_prim_ip['isys_catg_ip_list__domain'])) {
            $l_prim_ip['isys_catg_ip_list__domain'] = '.' . trim($l_prim_ip['isys_catg_ip_list__domain']);
        }

        $l_hostname_selection = ($l_catdata['isys_catg_cmk_list__host_name_selection'] === null)
            ? C__CATG_CHECK_MK__NAME_SELECTION__HOSTNAME
            : $l_catdata['isys_catg_cmk_list__host_name_selection'];

        $this->get_template_component()
            ->assign('hostname_obj_title', isys_check_mk_helper::prepare_valid_name($p_cat->get_obj_name_by_id_as_string($l_obj_id)))
            ->assign('hostname_hostname', trim($l_prim_ip['isys_catg_ip_list__hostname']))
            ->assign('hostname_hostname_fqdn', trim($l_prim_ip['isys_catg_ip_list__hostname']) . $l_prim_ip['isys_catg_ip_list__domain'])
            ->assign('host_name_view', isys_check_mk_helper::render_export_hostname($l_obj_id))
            ->assign('host_name_selection', $l_hostname_selection)
            ->assign('export_ip', !!$l_catdata['isys_catg_cmk_list__export_ip'])
            ->smarty_tom_add_rules("tom.content.bottom.content", $l_rules)
            ->include_template('contentbottomcontent', isys_module_check_mk::get_tpl_dir() . 'modules/cmdb/catg__cmk.tpl');
    }
}
