<?php

/**
 * i-doit
 *
 * Application Programming Interface (API).
 *
 * @package     i-doit
 * @subpackage  API
 * @author      Dennis Stücken <dstuecken@synetics.de>
 * @author      Benjamin Heisig <bheisig@synetics.de>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

use idoit\Module\Api\Logging\ApiLogger;

/**
 * API base class
 */
abstract class isys_api
{
    /**
     * Logger instance
     *
     * @var  isys_log
     */
    protected $m_log;

    /**
     * Indicating whether authentication
     * system should be used during api calls
     *
     * @var bool
     */
    protected $useAuth = false;

    /**
     * Initialize routine
     */
    protected function init()
    {
        global $g_config;

        // Create logger instance
        $this->m_log = ApiLogger::instance('api.logger');

        // Determine status of authentication system
        $this->useAuth = $g_config['use_auth'];
    }
}
