<?php

/**
 * i-doit APi
 *
 * @package    i-doit
 * @subpackage API
 * @author     Dennis Stücken <dstuecken@synetics.de>
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */
class isys_api_model_idoit_search implements isys_api_model_interface
{
    /**
     * @param array $p_params
     *
     * @return array
     * @throws \idoit\Module\Search\Query\Exceptions\NoQueryEngineException
     * @throws isys_exception_api
     */
    public function read($p_params)
    {
        global $g_config;

        // Check whether authentication system is active or not
        if ($g_config['use_auth'])
        {
            isys_auth_search::instance()->search();
        }

        if (!isset($p_params['q']))
        {
            throw new isys_exception_api('Missing parameter: "q".', -32601);
        }

        return \idoit\Module\Search\Query\QueryManager::factory()
            ->attachEngine(new \idoit\Module\Search\Query\Engine\Mysql\SearchEngine())
            ->addSearchKeyword($p_params['q'])
            ->search()
            ->getResult();
    } // function

    /**
     * Constructor
     */
    public function __construct()
    {
        ;
    }
}