<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Exception;

use Throwable;

/**
 * Class ValidationException
 *
 * @package idoit\Module\Api\Exception
 */
class ValidationException extends \Exception
{
    /**
     * ValidationException constructor.
     *
     * @param                $type
     * @param string         $message
     * @param int            $code
     * @param Throwable|null $previous
     */
    public function __construct($type, $message = "", $code = 0, Throwable $previous = null)
    {
        parent::__construct('(' . $type . ') ' . $message, $code, $previous);
    }
}