<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Session;

use isys_component_session;

/**
 * Class SystemUserSession
 *
 * @package idoit\Module\Api
 */
class SystemUserSession extends UserSession
{
    /**
     * Login
     *
     * @throws \isys_exception_api
     * @throws \Exception
     */
    public function login()
    {
        // Check whether requirements are met
        if (empty($this->getApiKey())) {
            throw new \Exception('Please provide a valid apikey information to create a user session.');
        }

        // Initialize session related data
        $this->initialize();

        // Check whether presistence is wanted and session exists already
        if ($this->isPersistent() && !empty($this->getSessionId())) {
            // Login via sessionId
            return $this->getSessionComponent()
                ->apikey_login($this->getApiKey(), null, $this->getSessionId());
        }

        // Reqular login via api key, username and password
        if ($this->getSessionComponent()
            ->apikey_login($this->getApiKey())) {
            // Set sessionId and userId
            $this->setSessionId($this->getSessionComponent()->get_session_id())
                ->setUserId($this->getSessionComponent()->get_user_id());

            return true;
        }

        return false;
    }

    /**
     * Get user id by credentials
     *
     * @param string $username
     * @param string $password
     *
     * @return int
     * @throws \Exception
     */
    public function getUserIdByCredentials($username, $password)
    {
        $sql = 'SELECT * FROM isys_obj object
                INNER JOIN isys_cats_person_list person ON object.isys_obj__id = person.isys_cats_person_list__isys_obj__id
                WHERE BINARY LOWER(person.isys_cats_person_list__title) = LOWER(\'systemapi\') AND
                      isys_cats_person_list__user_pass = \'\' AND object.isys_obj__status = ' . C__RECORD_STATUS__NORMAL . ';
        ';

        $resource = $GLOBALS['g_comp_database']->query($sql);

        if ($GLOBALS['g_comp_database']->num_rows($resource) == 1) {
            return (int)$GLOBALS['g_comp_database']->fetch_row_assoc($resource)['isys_obj__id'];
        }

        throw new \Exception('System user is not available. Please enforce user authentication and provide credentials with each client-side request.');
    }
}