<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Validation\Logical;

use idoit\Module\Api\Exception\ValidationException;

/**
 * Class IdValue
 *
 * @package Idoit\Module\Api\Validation\Logical
 */
class IdValue extends UnknownProperty
{
    /**
     * Validate value
     *
     * @return bool
     * @throws \idoit\Module\Api\Exception\ValidationException
     */
    public function validate()
    {
        if (!is_int($this->getValue()) || $this->getValue() <= 0) {
            throw new ValidationException('id', 'Category data id should be an integer value greater than zero.');
        }

        return true;
    }
}