<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Validation\Logical;

use idoit\Module\Api\Exception\ValidationException;
use idoit\Module\Api\Validation\Validation;

/**
 * Class ReadOnly
 *
 * @package Idoit\Module\Api\Validation\Logical
 */
class ReadOnly extends Validation
{
    /**
     * Validate value
     *
     * @return bool
     * @throws \idoit\Module\Api\Exception\ValidationException
     */
    public function validate()
    {
        // Check for readonly property
        if ($this->getPropertyDefinition()[C__PROPERTY__DATA][C__PROPERTY__DATA__READONLY]) {
            throw new ValidationException('**READ-ONLY**', 'Property is marked as read-only and cannot be modified.');
        }

        return true;
    }
}