<?php

/**
 * i-doit
 *
 * IT-Service DAO for the CMDB.
 *
 * @package     modules
 * @subpackage  itservice
 * @author      Pavel Abduramanov <pabduramanov@i-doit.com>
 * @version     1.0.0
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.10
 */
class isys_cmdb_dao_list_objects_it_service extends isys_cmdb_dao_list_objects
{
    /**
     * Method for retrieving additional conditions to a object type.
     *
     * @return  string
     * @author  Pavel Abduramanov <pabduramanov@i-doit.com>
     */
    public function get_additional_conditions()
    {
        $l_return = '';

        if (isset($_GET["id"])) {
            $l_return = " AND (its_type_list.isys_catg_its_type_list__isys_its_type__id = " . $this->convert_sql_id($_GET["id"]) . ") ";
        }

        return $l_return . parent::get_additional_conditions();
    }

    /**
     * Get additional join to the table, which is in use in additional conditions
     *
     * @return string
     */
    public function get_additional_joins()
    {
        if (isset($_GET["id"])) {
            return ' INNER JOIN isys_catg_its_type_list AS its_type_list ON its_type_list.isys_catg_its_type_list__isys_obj__id = obj_main.isys_obj__id';
        }

        return '';
    }
}
