<?php

/**
 * i-doit api module installer.
 *
 * @package     i-doit
 * @subpackage  cmk2
 * @author      Selcuk Kekec <skekec@i-doit.com>
 * @version     1.10
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 * @since       i-doit 1.12
 */
class isys_module_api_install
{
    /**
     * Init method.
     *
     * @param   isys_component_database $mandatorDb
     * @param   isys_component_database $systemDb
     * @param   integer                 $moduleId
     * @param   string                  $type
     * @param   integer                 $tenantId
     */
    public static function init($mandatorDb, $systemDb, $moduleId, $type, $tenantId = null)
    {
        // Check whether tenantId is set:
        if (!empty($tenantId)) {
            if ($type === 'install') {
                self::install($mandatorDb, $systemDb, $moduleId, $type, $tenantId);
            } else if ($type === 'update') {
                self::update($mandatorDb, $systemDb, $moduleId, $type, $tenantId);
            }
        }
    }

    /**
     * Update
     *
     * @param      $mandatorDb
     * @param      $systemDb
     * @param      $moduleId
     * @param      $type
     * @param null $tenantId
     *
     * @throws isys_exception_dao
     */
    public static function update($mandatorDb, $systemDb, $moduleId, $type, $tenantId = null)
    {
        // Create tenant settings dao
        $tenantSettingsDao = new isys_component_dao_tenant_settings($systemDb, $tenantId);

        // Create settings dao
        $systemSettingsDao = new isys_component_dao_settings($systemDb);

        // Get tenant settings:
        $tenantSettings = $tenantSettingsDao->get_settings();

        // Get system settings:
        $systemSettings = $systemSettingsDao->get_settings();

        if (!array_key_exists('api.validation', $systemSettings)) {
            $systemSettingsDao->set('api.validation', 1);
        }

        if (!array_key_exists('api.authenticated-users-only', $systemSettings)) {
            $systemSettingsDao->set('api.authenticated-users-only', 1);
        }

        if (!array_key_exists('api.status', $systemSettings)) {
            $systemSettingsDao->set('api.status', 1);
        }

        if (!array_key_exists('api.log-level', $systemSettings)) {
            $systemSettingsDao->set('api.log-level', 100);
        }

        $tenantSettingsDao->remove('api.use-auth');
        $systemSettingsDao->remove('api.use-auth');
        $tenantSettingsDao->remove('logging.system.api');
        $systemSettingsDao->remove('logging.system.api');
    }

    /**
     * Install
     *
     * @param isys_component_database $mandatorDb
     * @param isys_component_database $systemDb
     * @param                         $moduleId
     * @param                         $type
     * @param null                    $tenantId
     *
     * @throws isys_exception_dao
     */
    public static function install($mandatorDb, $systemDb, $moduleId, $type, $tenantId = null)
    {
        // Create tenant settings dao
        $tenantSettingsDao = new isys_component_dao_tenant_settings($systemDb, $tenantId);

        // Create settings dao
        $systemSettingsDao = new isys_component_dao_settings($systemDb);

        // Get tenant settings:
        $tenantSettings = $tenantSettingsDao->get_settings();

        // Get system settings:
        $systemSettings = $systemSettingsDao->get_settings();

        $systemSettingsDao->set('api.validation', 1);
        $systemSettingsDao->set('api.authenticated-users-only', 1);
        $systemSettingsDao->set('api.status', 1);
        $systemSettingsDao->set('api.log-level', 100); // Set to warning

        $tenantSettingsDao->remove('api.use-auth');
        $systemSettingsDao->remove('api.use-auth');
        $tenantSettingsDao->remove('logging.system.api');
        $systemSettingsDao->remove('logging.system.api');

        // Check whether mandator has an api key
        $resource = $systemDb->query('SELECT isys_mandator__apikey FROM isys_mandator WHERE isys_mandator__id = ' . $systemDb->escape_string($tenantId) .
            ' AND (isys_mandator__apikey IS NULL OR isys_mandator__apikey = "")');

        if ($systemDb->num_rows($resource)) {
            // Create a new random apu key
            $apiKey = substr(base_convert(sha1(uniqid(mt_rand())), 16, 36), 0, 16);

            // Prepare update sql to insert new api key for mandator
            $sql = 'UPDATE isys_mandator SET isys_mandator__apikey = \'' . $systemDb->escape_string($apiKey) . '\' WHERE isys_mandator__id = ' .
                $systemDb->escape_string($tenantId);

            // Execute query
            $systemDb->query($sql) && $systemDb->commit();
        }
    }
}