<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api\Dialog;

/**
 * Class DialogPlusAdmin
 *
 * @package idoit\Module\Api
 */
class DialogPlusAdmin extends DialogAdmin
{
    /**
     * Find or create id for provided value
     *
     * @param string $value
     *
     * @return false|int|null|string
     * @throws \isys_exception_dao
     * @throws \Exception
     */
    public function findOrCreate($value)
    {
        if ($this->valueExists($value)) {
            return (int)$this->getIdByValue($value);
        }

        if ($this->getMode() === self::MODE_TABLE) {
            $propertyDefinition = $this->getPropertyDefinition();

            // Property require some other data - Skip further processing
            if (!empty($propertyDefinition[C__PROPERTY__FORMAT__REQUIRES])) {
                return null;
            }

            $daoInstance = \isys_application::instance()->container->get('cmdb_dao');

            // Get table name
            $tableName = $propertyDefinition[C__PROPERTY__UI]['params']['p_strTable'] ?: $propertyDefinition[C__PROPERTY__DATA][C__PROPERTY__DATA__REFERENCES][0];

            // Create insert statement
            $sql = 'INSERT INTO ' . $tableName . ' SET ' . $tableName . '__title = ' . $daoInstance->convert_sql_text($value) . ',' . $tableName . '__status = ' .
                C__RECORD_STATUS__NORMAL . ';';

            // Create dialog entry and return its id
            if ($daoInstance->update($sql) && $daoInstance->apply_update()) {
                return (int)$daoInstance->get_last_insert_id();
            }
        }

        return null;
    }
}