<?php

/**
 * i-doit
 *
 * @package    i-doit
 * @subpackage API
 * @author     Selcuk Kekec <skekec@i-doit.de>
 * @version    1.10
 * @copyright  synetics GmbH
 * @license    http://www.i-doit.com/license
 */

namespace idoit\Module\Api;

use idoit\Module\Api\Response\ResponseStore;
use idoit\Module\Api\Response\RpcNotificationResponse;

/**
 * Class JsonRpcOutput
 *
 * @package idoit\Module\Api
 */
class JsonRpcOutput
{

    /**
     * ResponseStore
     *
     * @var ResponseStore;
     */
    protected $responseStore;

    /**
     * Get ResponseStore
     *
     * @return ResponseStore
     */
    public function getResponseStore()
    {
        return $this->responseStore;
    }

    /**
     * Set ResponseStore
     *
     * @param ResponseStore $responseStore
     */
    public function setResponseStore($responseStore)
    {
        $this->responseStore = $responseStore;
    }

    /**
     * Create JSON-RPC output
     *
     * @param bool $forceBatchOutput
     */
    public function output($forceBatchOutput = false)
    {
        $output = [];
        $responseStore = $this->getResponseStore();

        // Check for results first
        if ($responseStore->getResponses()) {
            foreach ($responseStore->getResponses() as $response) {
                if (!($response instanceof RpcNotificationResponse)) {
                    $output[] = $response->getResponse();
                }
            }
        }

        // Check whether output includes data
        if (count($output)) {
            // Check whether output has only one entry
            if (count($output) === 1 && !$forceBatchOutput) {
                $output = $output[0];
            }

            // Display response output
            header('Content-Type: application/json');
            echo \isys_format_json::encode($output);
        }
    }

    /**
     * JsonRpcOutput constructor.
     *
     * @param ResponseStore $responseStore
     */
    public function __construct(ResponseStore $responseStore)
    {
        $this->setResponseStore($responseStore);
    }
}