<?php

/**
 * i-doit
 *
 * Module initializer
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @version     1.1
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

define('C__GET__NAGIOS_PAGE', 'npID');
define('C__GET__NAGIOS_TPID', 'tpID');
define('C__GET__NAGIOS_CID', 'cID');
define('C__GET__NAGIOS_EID', 'eID');
define('C__GET__NAGIOS_NDOID', 'nID');
define('C__GET__NAGIOS_HOST_ID', 'hID');

define('C__NAGIOS_PAGE__CONFIG', 2);
define('C__NAGIOS_PAGE__TIMEPERIODS', 3);
define('C__NAGIOS_PAGE__COMMANDS', 4);
define('C__NAGIOS_PAGE__HOST_ESCALATIONS', 5);
define('C__NAGIOS_PAGE__SERVICE_ESCALATIONS', 6);
define('C__NAGIOS_PAGE__EXPORT', 7);

define('C__NAGIOS__PERSON_OPTION__OBJECT_TITLE', 0);
define('C__NAGIOS__PERSON_OPTION__USERNAME', 1);
define('C__NAGIOS__PERSON_OPTION__INPUT', 2);

define('C__CATG_NAGIOS_GROUP__TYPE_HOST', 0);
define('C__CATG_NAGIOS_GROUP__TYPE_SERVICE', 1);
define('C__CATG_NAGIOS__NAME_SELECTION__INPUT', 0);
define('C__CATG_NAGIOS__NAME_SELECTION__HOSTNAME_FQDN', 1);
define('C__CATG_NAGIOS__NAME_SELECTION__OBJ_ID', 2);
define('C__CATG_NAGIOS__NAME_SELECTION__HOSTNAME', 3);
define('C__CATG_NAGIOS__NAME_SELECTION__IP', 4);

if (isys_module_manager::instance()->is_active('nagios')) {
    require_once __DIR__ . '/isys_module_nagios_autoload.class.php';

    spl_autoload_register('isys_module_nagios_autoload::init');

    // Register the nagios handler.
    $GLOBALS['g_controller']['handler']['nagios'] = ['class' => 'isys_handler_nagios'];
    $GLOBALS['g_controller']['handler']['nagios_export'] = ['class' => 'isys_handler_nagios_export'];

    isys_component_signalcollection::get_instance()
        ->connect('mod.cmdb.processContentTop', ['isys_module_nagios', 'process_content_top']);

    \idoit\Psr4AutoloaderClass::factory()
        ->addNamespace('idoit\Module\Nagios', __DIR__ . '/src/');

    // Add tables to the dialog admin.
    isys_register::factory('additional-dialog-admin-tables')
        ->set('isys_nagios_timeperiods_plus')
        ->set('isys_nagios_commands_plus');
}
