<?php

/**
 * i-doit
 *
 * Workflow module class
 *
 * @package     Modules
 * @subpackage  Workflow
 * @version     1.0.0
 * @author      Viviane Götzen <vgoetzen@synetics.de>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_module_workflow extends isys_module implements isys_module_interface, isys_module_authable
{
    // Define, if this module shall be displayed in the named menus.
    const DISPLAY_IN_MAIN_MENU   = true;
    const DISPLAY_IN_SYSTEM_MENU = false;

    /**
     * Variable which the module request class.
     *
     * @var  isys_module_request
     */
    protected $m_modreq = null;

    /**
     * @var bool
     */
    private $hasTreeInitialized = false;

    /**
     * Initializes the module.
     *
     * @param   isys_module_request $p_req
     *
     * @return  isys_module_workflow
     */
    public function init(isys_module_request $p_req)
    {
        $this->m_modreq = $p_req;
        $this->m_dao    = new isys_workflow_dao(isys_application::instance()->container->get('database'));

        return $this;
    } // function

    /**
     * Method for retrieving the path to the module directory (needed for includes).
     *
     * @static
     * @return  string
     */
    public static function get_dir()
    {
        return __DIR__ . '/';
    } // function

    /**
     * @return $this|isys_module|isys_module_interface|string
     * @throws isys_exception_cmdb
     */
    public function start()
    {
        global $g_active_modreq;

        // Build the module tree, but only if we are not in the system-module.
        if ($_GET[C__GET__MODULE_ID] != C__MODULE__SYSTEM && !$this->hasTreeInitialized)
        {
            $l_tree = $g_active_modreq->get_menutree();

            $this->build_tree($l_tree, true, -1);

            $this->hasTreeInitialized = true;

            isys_application::instance()->container->get('template')
                ->assign("menu_tree", $l_tree->process($_GET[C__GET__TREE_NODE]));
        } // if

        // Message for an outdated maintenance contract (HTML allowed).
        define("C__WORKFLOW_MSG__MAINTENANCE", isys_application::instance()->container->settingsTenant->get(
            'email.template.maintenance',
            "Your maintenance contract: %s timed out.\n\n" . "<strong>Contract information</strong>:\n" . "Start: %s\n" . "End: %s\n" . "Support-Url: %s\n" .
            "Contract-Number: %s\n" . "Customer-Number: %s"
        ));

        if (!empty($_GET[C__CMDB__GET__VIEWMODE])) {
            global $index_includes;
            global $g_ajax;

            $viewManager = new isys_cmdb_view_manager($g_active_modreq);

            // Register workflow views
            if (class_exists('isys_workflow_view_tree')) {
                if (defined('C__WF__VIEW__TREE')) {
                    $viewManager->register("isys_workflow_view_tree", constant('C__WF__VIEW__TREE'));
                }
                if (defined('C__WF__VIEW__DETAIL__GENERIC')) {
                    $viewManager->register("isys_workflow_view_detail_generic", constant('C__WF__VIEW__DETAIL__GENERIC'));
                }
                if (defined('C__WF__VIEW__DETAIL__SELECTOR')) {
                    $viewManager->register("isys_workflow_view_detail_selector", constant('C__WF__VIEW__DETAIL__SELECTOR'));
                }
                if (defined('C__WF__VIEW__DETAIL__EMAIL_GUI')) {
                    $viewManager->register("isys_workflow_view_detail_email_gui", constant('C__WF__VIEW__DETAIL__EMAIL_GUI'));
                }
                if (defined('C__WF__VIEW__LIST')) {
                    $viewManager->register("isys_workflow_view_list_handler", constant('C__WF__VIEW__LIST'));
                }
                if (defined('C__WF__VIEW__LIST_TEMPLATE')) {
                    $viewManager->register("isys_workflow_view_list_template", constant('C__WF__VIEW__LIST_TEMPLATE'));
                }
                if (defined('C__WF__VIEW__DETAIL__TEMPLATE')) {
                    $viewManager->register("isys_workflow_view_detail_template", constant('C__WF__VIEW__DETAIL__TEMPLATE'));
                }
                if (defined('C__WF__VIEW__DETAIL__WF_TYPE')) {
                    $viewManager->register("isys_workflow_view_detail_wf_type", constant('C__WF__VIEW__DETAIL__WF_TYPE'));
                }
                if (defined('C__WF__VIEW__LIST_WF_TYPE')) {
                    $viewManager->register("isys_workflow_view_list_wf_type", constant('C__WF__VIEW__LIST_WF_TYPE'));
                }
                if (defined('C__WF__VIEW__LIST_FILTER')) {
                    $viewManager->register("isys_workflow_view_list_filter", constant('C__WF__VIEW__LIST_FILTER'));
                }
            }

            $l_viewdata = "";
            $l_gets = $g_active_modreq->get_gets();
            $l_posts = $g_active_modreq->get_posts();
            $l_tpl = $g_active_modreq->get_template();

            if (!$g_ajax || $g_ajax && !strstr($_GET[C__GET__AJAX_CALL], "tree")) {
                try {
                    $l_content_top = null;
                    $l_content_bottom = null;

                    /**
                     * @var isys_cmdb_view
                     */
                    $l_view = $viewManager->get_view($l_gets[C__CMDB__GET__VIEWMODE]);

                    if (is_object($l_view)) {
                        // Ask view object for its navigation parameters.
                        $l_view->get_mandatory_parameters($l_parameters_mandatory);
                        $l_view->get_optional_parameters($l_parameters_optional);

                        $GLOBALS["g_cmdb_view"] = &$l_view;

                        if ($l_posts[C__GET__NAVMODE] == C__NAVMODE__SAVE && $_GET[C__GET__AJAX] == '1') {
                            // Saving is regularly done via ajax so we don't need to process any views here.
                            if (method_exists($l_view, 'process_save')) {
                                $l_viewdata = $l_view->process_save();
                            }
                        } else {
                            $l_viewdata = $l_view->process();

                            // Does the view require a module request?
                            // @todo No view should require a reload of the cmdb module ! A reload is always a performance loss!
                            if ($l_view->requires_module_reload()) {
                                $l_view->trigger_module_reload();

                                // ... and restart the module.
                                return $this->start();
                            }
                        }

                        // Get filenames of templates associated with the view.
                        if (method_exists($l_view, 'get_template_top')) {
                            $l_content_top = $l_view->get_template_top();
                        }

                        if (method_exists($l_view, 'get_template_bottom')) {
                            $l_content_bottom = $l_view->get_template_bottom();
                        }

                        // Get name of template placeholder, where we write the data returned by process() in and assign it.
                        if (!empty($l_viewdata) && method_exists($l_view, 'get_template_destination')) {
                            $l_tpl->assign($l_view->get_template_destination(), $l_viewdata);
                        }
                    }
                } catch (isys_exception_auth $e) {
                    $l_tpl->assign('exception', $e->write_log());
                    $l_content_bottom = 'exception-auth.tpl';
                } catch (isys_exception $e) {
                    isys_application::instance()->container['notify']->error($e->getMessage());

                    return $e->getMessage();
                } catch (Exception $e) {
                    // Trigger system.exceptionTriggered, because this is not an isys_exception.
                    isys_component_signalcollection::get_instance()
                        ->emit('system.exceptionTriggered', $e);

                    isys_application::instance()->container['notify']->error($e->getMessage());

                    return $e->getMessage();
                }

                // Set content templates.
                if (isset($l_content_top) && $l_content_top != null) {
                    $index_includes["contenttop"] = $l_content_top;
                }

                if ($l_content_bottom != null) {
                    $index_includes["contentbottomcontent"] = $l_content_bottom;
                }

                // Emit viewProcessed.
                isys_component_signalcollection::get_instance()
                    ->emit("mod.cmdb.viewProcessed", isset($l_view) ? $l_view : null, $l_viewdata);
            }

        }

        return $this;
    }

    /**
     * This method builds the tree for the system menu.
     *
     * @param   isys_component_tree $p_tree
     * @param   boolean             $p_system_module
     * @param   integer             $p_parent
     *
     * @see     isys_module_cmdb->build_tree();
     */
    public function build_tree(isys_component_tree $p_tree, $p_system_module = true, $p_parent = null)
    {
        global $g_dirs;

        // Check if parent node is delivered
        if (null !== $p_parent && is_int($p_parent))
        {
            // Handle tree for system module
            if ($p_system_module)
            {
                $l_mod_gets[C__GET__MODULE_SUB_ID] = C__MODULE__WORKFLOW;

                $tree = new isys_workflow_view_tree($this->m_modreq);
                $tree->build_tree($p_tree, $p_system_module, -1);
            } // if
        } // if
    } // function

    /**
     * Get related auth class for module
     *
     * @author Selcuk Kekec <skekec@i-doit.com>
     * @return isys_auth|false
     */
    public static function get_auth()
    {
        return isys_auth_workflow::instance();
    }
}
