<?php
/**
 *
 *
 * @package     i-doit
 * @subpackage
 * @author      Pavel Abduramanov <pabduramanov@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

namespace idoit\Module\Console\Steps;

class PhpIniCheck extends Check
{
    /**
     * @var callable
     */
    private $callback;

    /**
     * @var string
     */
    private $settingName;

    /**
     * PhpIniCheck constructor.
     *
     * @param          $settingName
     * @param callable $check
     */
    public function __construct($settingName, callable $check)
    {
        $this->settingName = $settingName;
        $this->callback = $check;
    }

    /**
     * Get name of the step
     *
     * @return string
     */
    public function getName()
    {
        return 'Ini Setting: ' . $this->settingName;
    }

    /**
     * Check the requirements of the step
     *
     * @return mixed
     */
    public function check()
    {
        $value = ini_get($this->settingName);
        $callback = $this->callback;
        $res = (bool)$callback($value);
        return $res;
    }
}
