<?php
/**
 *
 *
 * @package     i-doit
 * @subpackage
 * @author      Pavel Abduramanov <pabduramanov@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

namespace idoit\Module\Console\Steps;

use Composer\Semver\Semver;

class VersionCheck extends Check
{
    /**
     * @var array
     */
    private $constraints;

    private $name;

    private $version;

    /**
     * PhpVersionCheck constructor.
     *
     * @param       $name
     * @param       $version
     * @param array $constraints
     */
    public function __construct($name, $version, array $constraints)
    {
        $this->name = $name;
        $this->version = $version;
        $this->constraints = $constraints;
    }

    /**
     * Get name of the step
     *
     * @return string
     */
    public function getName()
    {
        $name = $this->name . ' Version ' . $this->version . ': ';
        $name .= implode(', ', $this->constraints);

        return $name;
    }

    /**
     * Check the requirements of the step
     *
     * @return mixed
     */
    public function check()
    {
        $version = $this->version;
        $result = array_reduce($this->constraints, function ($carry, $item) use ($version) {
            return $carry && Semver::satisfies($version, $item);
        }, true);

        return $result;
    }
}
