<?php
/**
 *
 *
 * @package     i-doit
 * @subpackage
 * @author      Pavel Abduramanov <pabduramanov@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

namespace idoit\Module\Console\Steps\Sql;

use idoit\Module\Console\Steps\Step;
use mysqli;

abstract class SqlStep implements Step
{
    private $host;

    private $name;

    private $password;

    private $port;

    private $username;

    public function __construct(
        $host,
        $username,
        $password,
        $name,
        $port
    ) {
        $this->host = $host;
        $this->username = $username;
        $this->password = $password;
        $this->name = $name;
        $this->port = $port;
    }

    protected function createConnection()
    {
        return new mysqli($this->host, $this->username, $this->password, $this->name, $this->port);
    }
}
