<?php

namespace idoit\Module\License\Event\Tenant;

use Symfony\Component\EventDispatcher\Event;

class TenantAddedEvent extends Event
{
    /**
     * @var int
     */
    private $tenantId;

    const NAME = 'tenant.added';

    public function __construct($tenantId)
    {
        $this->tenantId = $tenantId;
    }

    /**
     * @return int
     */
    public function getTenantId()
    {
        return $this->tenantId;
    }
}
