<?php

/**
 * i-doit
 *
 * Class autoloader.
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Leonard Fischer <lfischer@i-doit.com>
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_module_qrcode_autoload extends isys_module_manager_autoload
{
    /**
     * @param  string $className
     *
     * @return bool
     */
    public static function init($className)
    {
        $addOnPath = '/src/classes/modules/qrcode/';
        $classMap = [
            'isys_qrcode_reportview_qr_codes' => 'reportview/isys_qrcode_reportview_qr_codes.class.php',
            'isys_ajax_handler_qrcode'        => 'handler/ajax/isys_ajax_handler_qrcode.class.php',
            'isys_module_qrcode_autoload'     => 'isys_module_qrcode_autoload.class.php',
            'isys_module_qrcode'              => 'isys_module_qrcode.class.php',
        ];

        if (isset($classMap[$className]) && parent::include_file($addOnPath . $classMap[$className])) {
            isys_cache::keyvalue()->ns('autoload')->set($className, $addOnPath . $classMap[$className]);

            return true;
        }

        return false;
    }
}
