<?php

/**
 * i-doit - Updates
 *
 * Migrating property provides to have filtering attribute
 *
 * @package     i-doit
 * @subpackage  Update
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */


/**
 * @var $g_comp_database isys_component_database
 */
global $g_comp_database;

// Set migrationId
$g_migration_identifier = "property_provides_migration";
if (!function_exists('getFixedSerializedTableConfig')) {
    function getFixedSerializedTableConfig($tableConfigSerialized)
    {
        global $g_comp_database;
        /**
         * @var $tableConfig \idoit\Module\Cmdb\Model\Ci\Table\Config
         */
        $tableConfig = unserialize($tableConfigSerialized);

        if ($tableConfig === false || !is_object($tableConfig) || (is_object($tableConfig) && !is_a($tableConfig, '\idoit\Module\Cmdb\Model\Ci\Table\Config'))) {
            return false;
        }

        /**
         * @var $property \idoit\Module\Cmdb\Model\Ci\Table\Property
         */
        foreach ($tableConfig->getProperties() as &$property) {
            $classname = $property->getClass();

            if (!is_a($classname, isys_cmdb_dao_category::class, true)) {
                continue;
            }

            /**
             * @var $obj isys_cmdb_dao_category
             */
            $obj = new $classname($g_comp_database);

            $classProperties = $obj->get_properties();

            if (isset($classProperties[$property->getKey()][C__PROPERTY__PROVIDES][C__PROPERTY__PROVIDES__FILTERABLE])) {
                $property->setFilterable($classProperties[$property->getKey()][C__PROPERTY__PROVIDES][C__PROPERTY__PROVIDES__FILTERABLE]);
            } else {
                $property->setFilterable(true);
            }
        }

        return serialize($tableConfig);
    }
}

// Check whether migration was executed before
if ($this->is_migration_done($g_migration_identifier)) {
    $g_migration_log[] = '<span class="bold">Migration of property provides has already been done.</span>';
} else {
    $g_migration_log[] = '<span class="bold">Starting Migration of property provides.</span>';

    // firstly fix table configs from isys_obj_type_list

    $tableConfigs = $g_comp_database->query('SELECT `isys_obj_type_list__id`,`isys_obj_type_list__table_config` FROM `isys_obj_type_list`');

    if ($tableConfigs) {
        $g_comp_database->begin();

        while ($row = $g_comp_database->fetch_row_assoc($tableConfigs)) {
            if (!$row['isys_obj_type_list__table_config']) {
                continue;
            }
            $fixedTableConfig = getFixedSerializedTableConfig($row['isys_obj_type_list__table_config']);

            if ($fixedTableConfig === false) {
                continue;
            }

            $updateSql = 'UPDATE `isys_obj_type_list`
                    SET `isys_obj_type_list__table_config` = \'' . $g_comp_database->escape_string($fixedTableConfig) . '\'
                    WHERE `isys_obj_type_list__id` = ' . $row['isys_obj_type_list__id'] . ';';

            $g_comp_database->query($updateSql);
        }

        $g_comp_database->commit();
    }

    // after that fix table configs from isys_obj_type_list

    $defaultTableConfig = $g_comp_database->query('SELECT * FROM `isys_settings` WHERE `isys_settings__key` LIKE \'cmdb.default-object-table.config%\';');

    if ($defaultTableConfig) {
        $g_comp_database->begin();

        while ($row = $g_comp_database->fetch_row_assoc($defaultTableConfig)) {
            if (!$row['isys_settings__value']) {
                continue;
            }
            $fixedTableConfig = getFixedSerializedTableConfig($row['isys_settings__value']);

            if ($fixedTableConfig === false) {
                continue;
            }

            $updateSql = 'UPDATE `isys_settings`
                    SET `isys_settings__value` = \'' . $g_comp_database->escape_string($fixedTableConfig) . '\'
                    WHERE `isys_settings__key` = \'' . $g_comp_database->escape_string($row['isys_settings__key']) . '\';';

            $g_comp_database->query($updateSql);
        }

        $g_comp_database->commit();

        // clean the cache
        try {
            isys_tenantsettings::regenerate();
        } catch (Exception $ex) {
        }
    }

    $g_migration_log[] = '<span class="bold">Migration finished!</span>';

    // Mark migration as done
    $this->migration_done($g_migration_identifier);
}
