<?php

namespace idoit\Module\License\Event\License;

use idoit\Module\License\Entity\License;
use Symfony\Component\EventDispatcher\Event;

class LicenseAddedEvent extends Event
{
    const NAME = 'license.added';

    /**
     * @var License
     */
    private $license;

    /**
     *
     * @param \idoit\Module\License\Entity\License $license
     */
    public function __construct($license)
    {
        $this->license = $license;
    }

    /**
     * @return License
     */
    public function getLicense()
    {
        return $this->license;
    }
}
