<?php

/**
 * i-doit
 *
 * Class autoloader.
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Dennis Stücken <dstuecken@i-doit.com>
 * @version     1.1
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
class isys_module_notifications_autoload extends isys_module_manager_autoload
{
    /**
     * Autoloader
     *
     * @param string $className
     *
     * @return boolean
     */
    public static function init($className)
    {
        $addOnPath = '/src/classes/modules/notifications/';
        $classList = [
            'isys_notifications_dao'  => 'dao/isys_notifications_dao.class.php',
            'isys_auth_notifications' => 'auth/isys_auth_notifications.class.php',
        ];

        if (isset($classList[$className]) && parent::include_file($addOnPath . $classList[$className])) {
            isys_caching::factory('autoload')->set($className, $addOnPath . $classList[$className]);

            return true;
        }

        return false;
    }
}
