[{isys_group name="tom.popup.visualization"}]
    <div id="visualization-popup">
        <h3 class="popup-header">
            <img class="fr mouse-pointer popup-closer" alt="x" src="[{$dir_images}]prototip/styles/default/close.png">

            <span>[{isys type="lang" ident="LC__MODULE__CMDB__VISUALIZATION__IT_SERVICE_SELECTION"}]</span>
        </h3>

        <div class="popup-content">
            <table class="w100 h100" cellspacing="0" cellpadding="0">
                <tr>
                    <td class="vat" style="width:240px; background: #eee; border-right: 1px solid #aaa; max-width:240px">
                        <h4 class="p5 gradient border-bottom text-shadow p10">[{isys type="lang" ident="LC__MODULE__CMDB__VISUALIZATION__IT_SERVICE_TYPES"}]</h4>

                        <ul id="C_VISUALIZATION_ITS_TYPES" class="list-style-none m0">
                            [{foreach $it_service_types as $it_service_type_id => $it_service_type_title}]
                                <li>
                                    <label>
                                        <input type="radio" name="C_VISUALIZATION_ITS_TYPE_SELECTION" value="[{$it_service_type_id}]" class="ml5 mr5" />
                                        <span>[{$it_service_type_title}]</span>
                                    </label>
                                </li>
                            [{/foreach}]
                        </ul>
                    </td>
                    <td class="vat">
                        <h4 class="p5 gradient border-bottom text-shadow p10">
                            [{isys type="f_text" name="C_VISUALIZATION_ITS_SEARCH" p_strClass="input input-small fr vam" p_bInfoIconSpacer=0 p_strPlaceholder="LC__PROPERTY_SELECTOR__SEARCH_IN_PROPERTIES" disableInputGroup=true}]
                            [{isys type="lang" ident="LC__MODULE__CMDB__VISUALIZATION__IT_SERVICES"}]
                        </h4>

                        <div id="C_VISUALIZATION_ITS_CONTAINER">
                            <!-- To be filled by AJAX -->
                        </div>
                    </td>
                </tr>
            </table>
        </div>

        <div class="popup-footer">
            <button type="button" class="btn popup-closer" id="visualization-popup-cancel">
                <img src="[{$dir_images}]icons/silk/cross.png" class="mr5" />
                <span>[{isys type="lang" ident="LC__VISUALIZATION_PROFILES__CLOSE_POPUP"}]</span>
            </button>
        </div>
    </div>
    <script type="text/javascript">
        (function () {
            'use strict';

            var $popup                  = $('visualization-popup'),
                $search                 = $('C_VISUALIZATION_ITS_SEARCH'),
                $itserviceTypeContainer = $('C_VISUALIZATION_ITS_TYPES'),
                $itserviceListContainer = $('C_VISUALIZATION_ITS_CONTAINER'),
                itsFilterTmp            = '';

            $popup.select('.popup-closer').invoke('on', 'click', function () {
                popup_close();
            });

            $search.on('keypress', function (event) {
                var itsFilter = $search.getValue().trim();

                // Prevent form submission
                if (event.keyCode == 13)
                {
                    delay(function () {
                        itsFilterTmp = itsFilter;

                        $itserviceListContainer.fire('reload:list');
                    }, 500, 'its.keypress');

                    event.preventDefault();
                }

                if (itsFilterTmp != itsFilter && (itsFilter.length === 0 || itsFilter.length >= 3))
                {
                    delay(function () {
                        itsFilterTmp = itsFilter;

                        $itserviceListContainer.fire('reload:list');
                    }, 500, 'its.keypress');
                }
            });

            $itserviceTypeContainer.on('change', 'input', function () {
                $search.setValue('');
                $itserviceListContainer.fire('reload:list');
            });

            $itserviceListContainer.on('reload:list', function () {
                var itsFilter = $search.getValue().trim();

                if (itsFilter.length < 3)
                {
                    itsFilter = '';
                }

                $itserviceListContainer.update(new Element('div', {className: 'm5'})
                    .update(new Element('img', {
                        src:       '[{$dir_images}]ajax-loading.gif',
                        className: 'vam mr5'
                    }))
                    .insert(new Element('span', {className: 'vam'}).update('[{isys type="lang" ident="LC__UNIVERSAL__LOADING"}]')));

                // Reloads the second chosen field.
                new Ajax.Request('[{$ajax_url}]', {
                    parameters: {
                        type:   $itserviceTypeContainer.down('input:checked').getValue().toLowerCase(),
                        filter: itsFilter
                    },
                    onComplete: function (response) {
                        var json = response.responseJSON, i, $ul = new Element('ul', {className: 'list-style-none m0'});

                        if (!is_json_response(response, true))
                        {
                            return;
                        }

                        if (json.success)
                        {
                            if (json.data.length === 0)
                            {
                                $itserviceListContainer.update(new Element('div', {className: 'p5 m5 box-blue'})
                                    .update(new Element('img', {
                                        src:       window.dir_images + 'icons/silk/information.png',
                                        className: 'vam mr5'
                                    }))
                                    .insert(new Element('span').update('[{isys type="lang" ident="LC__MODULE__CMDB__VISUALIZATION__NO_IT_SERVICES"}]')));
                            }
                            else
                            {
                                for (i in json.data)
                                {
                                    if (json.data.hasOwnProperty(i) && !isNaN(parseInt(i)))
                                    {
                                        $ul.insert(new Element('li', {
                                            className:     'service-selection',
                                            'data-object': i
                                        })
                                            .insert(new Element('span', {title: json.data[i]})
                                                .update(new Element('img', {src: '[{$dir_images}]icons/silk/link.png'}))
                                                .insert(json.data[i])));
                                    }
                                }

                                $itserviceListContainer.update($ul);

                                if (json.data.hasOwnProperty('limit'))
                                {
                                    $itserviceListContainer.insert({
                                        top:
                                            new Element('div', {className: 'm5 p5 box-blue'})
                                                .update(new Element('img', {
                                                    src:       window.dir_images + 'icons/silk/information.png',
                                                    className: 'vam mr5'
                                                }))
                                                .insert(new Element('span').update(json.data.limit))
                                    });
                                }
                            }
                        }
                        else
                        {
                            idoit.Notify.error(json.message);
                        }
                    }
                });
            });

            $itserviceListContainer.on('click', 'li[data-object]', function (ev) {
                var $el = ev.findElement('li');

                $('C_VISUALIZATION_OBJ_SELECTION__VIEW')
                    .setValue('[{isys type="lang" ident="LC__OBJTYPE__IT_SERVICE"}] >> ' + ($el.down('span').textContent || $el.down('span').innerText));
                $('C_VISUALIZATION_OBJ_SELECTION__HIDDEN').setValue($el.readAttribute('data-object'));

                popup_close();

                idoit.callbackManager.triggerCallback('visualization-init-explorer');
            });

            // Clicks the first type "all" on startup.
            $itserviceTypeContainer.down('input').simulate('click');

            // Focus the search field.
            $search.focus();
        })();
    </script>
    <style>
        #visualization-popup {
            box-sizing: border-box;
            position: relative;
            height: 100%;
        }

        #visualization-popup li {
            border-bottom: 1px solid #ccc;
        }

        #visualization-popup li.service-selection {
            line-height: 22px;
            display: block;
            height: 25px;
            padding: 0 5px;
            cursor: pointer;
        }

        #visualization-popup li.service-selection:hover {
            background-color: #eee;
        }

        #visualization-popup label {
            display: block;
        }

        #C_VISUALIZATION_ITS_SEARCH {
            height: 21px;
            margin-top: -3px;
        }

        #C_VISUALIZATION_ITS_CONTAINER {
            max-height: 92%;
            overflow-y: auto;
        }

        #C_VISUALIZATION_ITS_CONTAINER li img {
            float: left;
            margin: 4px 5px 0 0;
        }

        #C_VISUALIZATION_ITS_CONTAINER li span {
            width: 540px;
            overflow: hidden;
            text-overflow: ellipsis;
            white-space: nowrap;
            float: left;
        }

        #C_VISUALIZATION_ITS_TYPES span {
            white-space: nowrap;
            overflow: hidden;
            text-overflow: ellipsis;
            max-width: 200px;
            display: inline-block;
        }
    </style>
[{/isys_group}]
