<?php

/**
 * i-doit - Updates
 *
 * Migrating files and images from upload directories
 *
 * @package     i-doit
 * @subpackage  Update
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */


/**
 * @var $g_comp_database isys_component_database
 */
global $g_comp_database, $g_comp_database_system, $g_dirs;

// Set migrationId
$g_migration_identifier = "move_uploaded_files_migration";

// Check whether migration was executed before
if ($this->is_migration_done($g_migration_identifier)) {
    $g_migration_log[] = '<span class="bold">Uploaded files have already been migrated.</span>';
} else {
    $g_migration_log[] = '<span class="bold">Starting migration of moving uploaded files.</span>';

    // move uploaded images
    $tenants = $g_comp_database_system->retrieveArrayFromResource($g_comp_database_system->query('SELECT isys_mandator__id FROM isys_mandator WHERE TRUE'));
    foreach ($tenants as $tenant) {
        $tenantImagesDirectory = $g_dirs['fileman']['image_dir'] . $tenant['isys_mandator__id'] . DS;
        if (!file_exists($tenantImagesDirectory) && !mkdir($tenantImagesDirectory) && !is_dir($tenantImagesDirectory)) {
            throw new \RuntimeException(sprintf('Upload images directory "%s" was not created', $tenantImagesDirectory));
        }

        $files = dir($tenantImagesDirectory);
        // Move all images into tenant directory
        while($file = $files->read()) {
            if (strpos($file, '.') !== 0 && !is_dir($tenantImagesDirectory . $file)) {
                $newDirectoryPath = $tenantImagesDirectory . substr(md5($file), 0, 2) . DS;
                if (!file_exists($newDirectoryPath) && !mkdir($newDirectoryPath) && !chmod($newDirectoryPath, 775)) {
                    throw new \RuntimeException(sprintf('Upload images subdirectory "%s" was not created', $newDirectoryPath));
                }
                rename($tenantImagesDirectory . $file, $newDirectoryPath . $file);
            }
        }
    }

    // move uploaded files
    $uploadFilesDirectory = $g_dirs['fileman']['target_dir'];
    if (!file_exists($uploadFilesDirectory) && !mkdir($uploadFilesDirectory) && !is_dir($uploadFilesDirectory)) {
        throw new \RuntimeException(sprintf('Upload files directory "%s" was not created', $uploadFilesDirectory));
    }
    $files = dir($uploadFilesDirectory);
    while($file = $files->read()) {
        if (strpos($file, '.') !== 0 && !is_dir($uploadFilesDirectory . $file)) {
            $newDirectoryPath = $uploadFilesDirectory . substr(md5($file), 0, 2) . DS;
            if (!file_exists($newDirectoryPath) && !mkdir($newDirectoryPath, 0775) && !chmod($newDirectoryPath, 775)) {
                throw new \RuntimeException(sprintf('Upload files subdirectory "%s" was not created', $newDirectoryPath));
            }
            rename($uploadFilesDirectory . $file, $newDirectoryPath . $file);
        }
    }

    $g_migration_log[] = '<span class="bold">Migration finished!</span>';

    // Mark migration as done
    $this->migration_done($g_migration_identifier);
}
