<?php

namespace idoit\Module\Search\Query\Protocol;

/**
 * i-doit
 *
 * Query result protocol
 *
 * @package     i-doit
 * @subpackage  Modules
 * @author      Dennis Stücken <dstuecken@i-doit.com>
 * @version     1.7
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */
interface QueryResult
{

    /**
     * Add a query result item to this result
     *
     * @param QueryResultItem $item
     *
     * @return mixed
     */
    public function addItem(QueryResultItem $item);

    /**
     * Get result items
     *
     * @return QueryResultItem[]
     */
    public function getResult();

}