[{isys_group name="tom.popup.visualization"}]
<div id="visualization-popup">
    <h3 class="p10 border-bottom gradient">
        <img class="fr mouse-pointer popup-closer" alt="x" src="[{$dir_images}]icons/close-circle.png">

        <span>[{isys type="lang" ident="LC__VISUALIZATION_EXPORT__POPUP_TITLE"}]</span>
    </h3>

    <div id="visualization-popup-content" class="p5">
        <h4 class="border gradient p5">[{isys type="lang" ident="LC__VISUALIZATION_EXPORT__TYPE"}]</h4>

        <label class="ml5">
            <input type="radio" name="visualization-popup-export-type" class="mr5" value="png-full" checked="checked" />
            <span>[{isys type="lang" ident="LC__VISUALIZATION_EXPORT__TYPE__PNG_FULL"}]</span>
        </label>

        <label class="mt5 ml5">
            <input type="radio" name="visualization-popup-export-type" class="mr5" value="png-cropped" />
            <span>[{isys type="lang" ident="LC__VISUALIZATION_EXPORT__TYPE__PNG_CROPPED"}]</span>
        </label>

        <label class="mt5 ml5">
            <input type="radio" name="visualization-popup-export-type" class="mr5" value="svg-full" />
            <span>[{isys type="lang" ident="LC__VISUALIZATION_EXPORT__TYPE__SVG_FULL"}]</span>
        </label>

        <label class="mt5 ml5">
            <input type="radio" name="visualization-popup-export-type" class="mr5" value="svg-cropped" />
            <span>[{isys type="lang" ident="LC__VISUALIZATION_EXPORT__TYPE__SVG_CROPPED"}]</span>
        </label>

        <label class="mt5 ml5">
            <input type="radio" name="visualization-popup-export-type" class="mr5" value="graphml" />
            <span>[{isys type="lang" ident="LC__VISUALIZATION_EXPORT__TYPE__GRAPHML"}]</span>
        </label>

        <!-- For later use :)
    <h4 class="border gradient p5">[{isys type="lang" ident="LC__VISUALIZATION_EXPORT__OPTIONS"}]</h4>

    <table class="contentTable">
        <tr>
            <td class="key">key</td>
            <td class="value">value</td>
        </tr>
    </table>
    -->
    </div>

    <div id="visualization-popup-footer" class="border-top">
        <button type="button" class="btn m5" id="visualization-popup-save">
            <img src="[{$dir_images}]icons/silk/disk.png" class="mr5" />
            <span>[{isys type="lang" ident="LC__VISUALIZATION_EXPORT"}]</span>
        </button>

        <button type="button" class="btn m5 popup-closer" id="visualization-popup-cancel">
            <img src="[{$dir_images}]icons/silk/cross.png" class="mr5" />
            <span>[{isys type="lang" ident="LC__UNIVERSAL__BUTTON_CANCEL_CLOSE"}]</span>
        </button>
    </div>
</div>
<script type="text/javascript">
    (function () {
        'use strict';

        var $popup         = $('visualization-popup'),
            $content       = $('visualization-popup-content'),
            $footer        = $('visualization-popup-footer'),
            $accept_button = $('visualization-popup-save'),
            $canvas        = $('C_VISUALIZATION_CANVAS');

        $popup.select('.popup-closer').invoke('on', 'click', function () {
            popup_close();
        });

        // We need this snippet to size the content area correctly, so we don't scroll the header and footer as well. Also the "undeletable" profiles get disabled.
        $content.setStyle({height: ($popup.getHeight() - ($popup.down('h3').getHeight() + $footer.getHeight())) + 'px'});

        $accept_button.on('click', function () {
            var date        = new Date(),
                export_type = $content.down('[name="visualization-popup-export-type"]:checked').getValue(),
                fileName    = 'cmdb-export_' + date.getFullYear() + '-' + ('0' + (1 + date.getMonth())).substr(-2, 2) + '-' + ('0' + date.getDate()).substr(-2, 2);

            switch (export_type) {
                case 'png-full':
                    prepareFullSvg().saveToPng({filename: fileName, scale: 2});
                    break;

                case 'png-cropped':
                    $canvas
                        .down('svg')
                        .saveToPng({filename: fileName, scale: 2});
                    break;

                case 'svg-full':
                    prepareFullSvg().saveToSvg({filename: fileName});
                    break;

                case 'svg-cropped':
                    $canvas
                        .down('svg')
                        .saveToSvg({filename: fileName});
                    break;

                case 'graphml':
                    // Trigger the download.
                    document.location.href = '[{$export_url}]' +
                        '&object=' + $F('C_VISUALIZATION_OBJ_SELECTION__HIDDEN') +
                        '&profile=' + $F('C_VISUALIZATION_PROFILE') +
                        '&service-filter=' + $F('C_VISUALIZATION_SERVICE_FILTER');
                    break;
            }
        });

        /**
         * This function will create a element which contains a 1:1 copy of the canvas' SVG.
         * Only difference is, that this element will be sized to display its content in full
         * and update the `transform="translate(...)"` values accordingly.
         *
         * @returns {*}
         */
        function prepareFullSvg() {
            var $nodes      = $canvas.select('.node'),
                $printView  = new Element('div'),
                match,
                i,
                matchRegExp = /translate\(([-\d\.]*),?\s*([-\d\.]*)\)/,
                boundingBox = {width: 200, height: 50},
                minX        = 0,
                minY        = 0,
                maxX        = 0,
                maxY        = 0;

            if ($nodes[0]) {
                try {
                    boundingBox = $nodes[0].getBBox();
                } catch (e) {
                    try {
                        // Using `getBoundingClientRect` as fallback (for example for IE 11).
                        boundingBox = $nodes[0].getBoundingClientRect();
                    } catch (e) {
                        // Do nothing, use the defaults.
                    }
                }
            }

            for (i in $nodes) {
                if (!$nodes.hasOwnProperty(i)) {
                    continue;
                }

                try {
                    match = Element.readAttribute($nodes[i], 'transform').match(matchRegExp);

                    // Get minimum X and Y coordinates.
                    minX = Math.min(minX, parseInt(match[1]));
                    minY = Math.min(minY, parseInt(match[2]));

                    // Get maximum X and Y coordinates.
                    maxX = Math.max(maxX, parseInt(match[1]));
                    maxY = Math.max(maxY, parseInt(match[2]));
                } catch (e) {
                    // Do nothing
                }
            }

            // Add the node width and height to the dimensions (will also create a nice margin).
            minX = Math.abs(minX) + (boundingBox.width * 1.5);
            minY = Math.abs(minY) + boundingBox.height;
            maxX += (boundingBox.width * 1.5);
            maxY += boundingBox.height;

            // Pass the element to D3 since it can handle SVG elements.
            $printView = d3.select($printView.update($canvas.innerHTML));

            // Select the SVG, alter some attributes (+ some attributes of the direct <g> descendants) and return the node.
            return $printView.select('svg')
                .attr('viewBox', '0 0 ' + (minX + maxX) + ' ' + (minY + maxY))
                .attr('width', (minX + maxX))
                .attr('height', (minY + maxY))
                .call(function (svg) {
                    svg.selectAll('svg > g').attr('transform', 'translate(' + minX + ',' + minY + ') scale(1)');
                })
                .node();
        }
    })();
</script>
<style>
    #visualization-popup {
        box-sizing: border-box;
        position: relative;
        height: 100%;
    }

    #visualization-popup #visualization-popup-content {
        overflow-y: auto;
    }

    #visualization-popup #visualization-popup-content label {
        display: block;
    }

    #visualization-popup #visualization-popup-content table td.key {
        width: 150px;
    }

    #visualization-popup #visualization-popup-footer {
        position: absolute;
        bottom: 0;
        width: 100%;
        background: #eee;
    }
</style>
[{/isys_group}]
