<?php

/**
 * i-doit - Updates
 *
 * Migrating plug types
 *
 * @package     i-doit
 * @subpackage  Update
 * @copyright   synetics GmbH
 * @license     http://www.i-doit.com/license
 */

global $g_comp_database_system;

// Set migration ID.
$g_migration_identifier = "auth_log_migration";

// Check whether migration has been executed before.
if ($this->is_migration_done($g_migration_identifier)) {
    $g_migration_log[] = '<span class="bold">Migration of auth logging.</span>';
} else {
    $g_migration_log[] = '<span class="bold">Starting Migration of auth logging.</span>';

    if (isset($tenantId) && is_numeric($tenantId)) {
        $dao = isys_cmdb_dao::instance($g_comp_database_system);

        $sql = "SELECT isys_settings__value AS val
            FROM isys_settings 
            WHERE isys_settings__key LIKE 'auth.logging'
            AND isys_settings__isys_mandator__id = {$tenantId};";

        $value = $dao->retrieve($sql)->get_row_value('val');

        // If no value is set, set the old default (1).
        if ($value === null) {
            $sql = "INSERT INTO isys_settings
                SET isys_settings__value = 1,
                isys_settings__key = 'auth.logging',
                isys_settings__isys_mandator__id = {$tenantId};";

            $dao->update($sql);
            $dao->apply_update();
        }

        // Mark migration as done.
        $this->migration_done($g_migration_identifier);
    }
}
