<?php

namespace idoit\Module\Cmdb\Component\CategoryChanges\Type\Browser;

use idoit\Module\Cmdb\Component\CategoryChanges\Type\AbstractType;
use isys_cmdb_dao;
use isys_tenantsettings;

/**
 * Class AbstractBrowserType
 *
 * @package idoit\Module\Cmdb\Component\CategoryChanges\Type\Browser
 */
abstract class AbstractBrowserType extends AbstractType
{
    /**
     * @var int|null
     */
    protected $fromObjectId = null;

    /**
     * @var int|null
     */
    protected $toObjectId = null;

    /**
     * @var string|null
     */
    protected $backwardPropertyTag = null;

    /**
     * @var string|null
     */
    protected $propertyTag = null;

    /**
     * @return int
     */
    public function getFromObjectId()
    {
        return $this->fromObjectId;
    }

    /**
     * @param int|null $fromObjectId
     *
     * @return static
     */
    public function setFromObjectId(int $fromObjectId = null)
    {
        $this->fromObjectId = $fromObjectId;
        return $this;
    }

    /**
     * @return int|null
     */
    public function getToObjectId()
    {
        return $this->toObjectId;
    }

    /**
     * @param int|null $toObjectId
     *
     * @return static
     */
    public function setToObjectId(int $toObjectId = null)
    {
        $this->toObjectId = $toObjectId;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getBackwardPropertyTag()
    {
        return $this->backwardPropertyTag;
    }

    /**
     * @param string|null $backwardProperty
     *
     * @return static
     */
    public function setBackwardPropertyTag(string $backwardProperty = null)
    {
        $this->backwardPropertyTag = $backwardProperty;
        return $this;
    }

    /**
     * @return string|null
     */
    public function getPropertyTag()
    {
        return $this->propertyTag;
    }

    /**
     * @param string|null $propertyTag
     *
     * @return static
     */
    public function setPropertyTag(string $propertyTag = null)
    {
        $this->propertyTag = $propertyTag;
        return $this;
    }


    /**
     * @param int           $objectId
     * @param isys_cmdb_dao $dao
     *
     * @return string
     * @throws \isys_exception_database
     */
    public function getObjectTitle(int $objectId, isys_cmdb_dao $dao)
    {
        $separator = isys_tenantsettings::get('gui.separator.connector', ' > ');
        $objectData = $dao->get_object($objectId, false, 1)->get_row();
        return $this->getLanguage()->get($objectData['isys_obj_type__title']) . $separator . $objectData['isys_obj__title'];
    }
}
