<?php

namespace idoit\Module\Cmdb\Component\CategoryChanges\Type\Browser;

use idoit\Component\Property\Property;
use idoit\Module\Cmdb\Component\CategoryChanges\Data\DataProvider;
use idoit\Module\Cmdb\Component\CategoryChanges\Data\DefaultData;
use idoit\Module\Cmdb\Component\CategoryChanges\Data\RequestData;
use idoit\Module\Cmdb\Component\CategoryChanges\Data\SmartyData;
use idoit\Module\Cmdb\Component\CategoryChanges\Type\TypeInterface;
use isys_cmdb_dao;
use isys_cmdb_dao_category;
use isys_cmdb_dao_category_g_location;
use isys_format_json;
use isys_popup_browser_location;

/**
 * Class LocationBrowserType
 *
 * Special type for location browser
 *
 * @package idoit\Module\Cmdb\Component\CategoryChanges\Type
 */
class LocationBrowserType extends ObjectBrowserType implements TypeInterface, ObjectBrowserTypeInterface
{
    /**
     * @param Property $property
     * @param string   $tag
     *
     * @return bool
     */
    public function isApplicable(Property $property, string $tag)
    {
        return $property->getInfo()->getType() === Property::C__PROPERTY__INFO__TYPE__OBJECT_BROWSER &&
            $property->getUi()->getParams()['p_strPopupType'] === 'browser_location';
    }

    /**
     * @param int           $objectId
     * @param isys_cmdb_dao $dao
     *
     * @return string
     * @throws \isys_exception_database
     */
    public function getObjectTitle(int $objectId, isys_cmdb_dao $dao)
    {
        $locationBrowserInstance = isys_popup_browser_location::instance(\isys_application::instance()->container->get('database'));

        $locationPath = $locationBrowserInstance
            ->set_format_as_text(true)
            ->format_selection($objectId);

        return $locationPath;
    }

    /**
     * @param DefaultData $currentData
     * @param DefaultData $changedData
     *
     * @return array
     */
    public function handleData(DefaultData $currentData, DefaultData $changedData)
    {
        // TODO: Implement handleData() method.
    }
}
