<?php

namespace idoit\Module\Cmdb\Component\CategoryChanges\Type;

use idoit\Component\Property\Property;
use idoit\Module\Cmdb\Component\CategoryChanges\Data\ChangesData;
use idoit\Module\Cmdb\Component\CategoryChanges\Data\DefaultData;
use idoit\Module\Cmdb\Component\CategoryChanges\Data\RequestData;
use idoit\Module\Cmdb\Component\CategoryChanges\Data\SmartyData;
use isys_callback;
use isys_cmdb_dao_category;
use isys_format_json;
use isys_tenantsettings;

/**
 * Class DialogDataType
 *
 * @package idoit\Module\Cmdb\Component\CategoryChanges\Type
 */
class DialogDataType extends AbstractType implements TypeInterface
{
    /**
     * @param Property $property
     * @param string   $tag
     *
     * @return bool
     */
    public function isApplicable(Property $property, string $tag)
    {
        $params = $property->getUi()->getParams();
        return $property->getInfo()->getType() === Property::C__PROPERTY__INFO__TYPE__DIALOG && is_array($params) && isset($params['p_arData']);
    }

    /**
     * @param string                 $tag
     * @param isys_cmdb_dao_category $dao
     * @param RequestData            $requestDataProvider
     * @param SmartyData             $smartyDataProvider
     * @param array                  $currentData
     *
     * @return array
     * @throws \idoit\Exception\JsonException
     */
    public function handlePostData(string $tag, isys_cmdb_dao_category $dao, RequestData $requestDataProvider, SmartyData $smartyDataProvider, array $currentData = [])
    {
        $requestData = $requestDataProvider->getData();
        $smartyData = $smartyDataProvider->getData();
        $property = $this->getProperty();
        $uiField = $property->getUi()->getId();
        $currentObjectId = $dao->get_object_id();
        $currentPropertyTag = $this->getCurrentPropertyTag($dao, $tag);
        $changes = [];
        $newValue = $oldValue = isys_tenantsettings::get('gui.empty_value', '-');
        $currentPropertyTag = get_class($dao) . '::' . $tag;

        if (!isset($smartyData[$uiField])) {
            return [];
        }

        $newValueId = trim($requestData[$uiField]);
        $oldValueId = trim($smartyData[$uiField]['p_strSelectedID']);
        $rawData = $smartyData[$uiField]['p_arData'] ?? [];

        if (empty($data) || $newValueId === $oldValueId || ($newValueId === '' && $oldValueId == -1)) {
            return [];
        }

        if (is_string($rawData)) {
            $data = isys_format_json::is_json_array($rawData) ?
                isys_format_json::decode($rawData) : unserialize($rawData);
        } elseif ($rawData instanceof isys_callback) {
            $data = $rawData->execute();
        } else {
            $data = $rawData;
        }

        if ($oldValueId >= 0 || $oldValueId !== '') {
            $oldValue = $data[$oldValueId];
        }

        if ($newValueId >= 0 || $newValueId !== '') {
            $newValue = $data[$newValueId];
        }

        $changes = ChangesData::factory(
            [
                $currentPropertyTag => [
                    self::CHANGES_FROM => $oldValue,
                    self::CHANGES_TO =>  $newValue
                ]
            ],
            $currentObjectId
        );

        return [
            self::CHANGES_CURRENT => $changes,
            self::CHANGES_TO => $changes,
        ];
    }

    public function handleData(DefaultData $currentData, DefaultData $changedData)
    {
        // TODO: Implement handleData() method.
    }
}
