<?php

namespace idoit\Module\Cmdb\Component\CategoryChanges\Data;

use isys_cmdb_dao_category;

/**
 * Class DefaultData
 *
 * @package idoit\Module\Cmdb\Component\CategoryChanges\Data
 */
class DefaultData extends AbstractData
{
    /**
     * @var isys_cmdb_dao_category
     */
    private $dao;

    /**
     * @return isys_cmdb_dao_category
     */
    public function getDao()
    {
        return $this->dao;
    }

    /**
     * @param isys_cmdb_dao_category $dao
     *
     * @return DefaultData
     */
    public function setDao(isys_cmdb_dao_category $dao)
    {
        $this->dao = $dao;
        return $this;
    }

    /**
     * @param int                    $objectId
     * @param int|null               $entryId
     *
     * @return DefaultData
     */
    public function loadData(int $objectId, ?int $entryId = null)
    {
        $dataResult = $this->getDao()->get_data($entryId, $objectId);
        $this->setData($dataResult->get_row());

        return $this;
    }

    /**
     * @param mixed $data
     *
     * @return static
     */
    public static function factory(isys_cmdb_dao_category $dao, $data)
    {
        $object = new static();
        $object->setData($data);
        $object->setDao($dao);

        return $object;
    }

    /**
     * @param PropertyData $propertyData
     *
     * @return $this
     */
    public function reformat(PropertyData $propertyData)
    {
        $propertyData = $propertyData->getData();

        foreach ($propertyData[get_class($this->getData())] as $key => $value) {
        }

        return $this;
    }
}
