<?php

namespace idoit\Module\Cmdb\Component\CategoryChanges\Type;

use idoit\Component\Property\Property;
use idoit\Component\Property\Type\TimeperiodProperty;
use idoit\Module\Cmdb\Component\CategoryChanges\Data\ChangesData;
use idoit\Module\Cmdb\Component\CategoryChanges\Data\DefaultData;
use idoit\Module\Cmdb\Component\CategoryChanges\Data\RequestData;
use idoit\Module\Cmdb\Component\CategoryChanges\Data\SmartyData;
use isys_application;
use isys_cmdb_dao_category;

/**
 * Class DateTimeperiodType
 *
 * @package idoit\Module\Cmdb\Component\CategoryChanges\Type
 */
class DateTimeperiodType extends AbstractType implements TypeInterface
{
    /**
     * @param Property $property
     * @param string   $tag
     *
     * @return bool
     */
    public function isApplicable(Property $property, string $tag)
    {
        return $property->getInfo()->getType() === Property::C__PROPERTY__INFO__TYPE__TIMEPERIOD;
    }

    /**
     * @param string                 $tag
     * @param isys_cmdb_dao_category $dao
     * @param RequestData            $requestDataProvider
     * @param SmartyData             $smartyDataProvider
     * @param array                  $currentData
     *
     * @return array
     */
    public function handlePostData(string $tag, isys_cmdb_dao_category $dao, RequestData $requestDataProvider, SmartyData $smartyDataProvider, array $currentData = [])
    {
        $requestData = $requestDataProvider->getData();
        $smartyData = $smartyDataProvider->getData();
        $property = $this->getProperty();
        $uiField = $property->getUi()->getId();
        $fromAddition = TimeperiodProperty::UI_ID_ADDITION_FROM;
        $toAddition = TimeperiodProperty::UI_ID_ADDITION_TO;

        if ((strpos(strrev($uiField), strrev($fromAddition)) === 0)) {
            $uiField = strrev(str_replace(strrev($fromAddition), '', strrev($uiField), 1));
        } elseif ((strpos(strrev($uiField), strrev($toAddition)) === 0)) {
            $uiField = strrev(str_replace(strrev($toAddition), '', strrev($uiField), 1));
        }

        $uiFieldFrom = $uiField . $fromAddition;
        $uiFieldTo = $uiField . $toAddition;

        $currentObjectId = $dao->get_object_id();
        $currentPropertyTag = $this->getCurrentPropertyTag($dao, $tag);
        $newValueFrom = $requestData[$uiFieldFrom] ?? '';
        $newValueTo = $requestData[$uiFieldTo] ?? '';
        $oldValueFrom = $smartyData[$uiFieldFrom]['p_strValue'];
        $oldValueTo = $smartyData[$uiFieldTo]['p_strValue'];

        if ($newValueFrom === $oldValueFrom && $newValueTo === $oldValueTo) {
            return [];
        }

        $changes = ChangesData::factory(
            [
                $currentPropertyTag => [
                    self::CHANGES_FROM => $oldValueFrom . ' - ' . $oldValueTo,
                    self::CHANGES_TO => $newValueFrom . ' - ' . $newValueTo
                ]
            ],
            $currentObjectId
        );

        return [
            self::CHANGES_CURRENT => $changes,
            self::CHANGES_TO => $changes,
        ];
    }

    /**
     * @param DefaultData $currentData
     * @param DefaultData $changedData
     *
     * @return array
     */
    public function handleData(DefaultData $currentData, DefaultData $changedData)
    {
        // TODO: Implement handleData() method.
    }
}
